﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectCombiner.Primitives.Generation.AutoGen.Operators
{
    public class ClampOperatorDefinitionSet : BuiltInFunctionDefinitionSet
    {
        public ClampOperatorDefinitionSet()
            : base(
            "clamp",
            "Clamp",
            "{1E30E032-AADA-47B5-B65A-2476A6338D3E}",
            new[] { "x", "min", "max" },
            new[]
            {
                new[] { "float", "float", "float", "float" },
                new[] { "vec2", "vec2", "vec2", "vec2" },
                new[] { "vec3", "vec3", "vec3", "vec3" },
                new[] { "vec4", "vec4", "vec4", "vec4" },
                new[] { "vec2", "vec2", "float", "float" },
                new[] { "vec3", "vec3", "float", "float" },
                new[] { "vec4", "vec4", "float", "float" },
                new[] { "double", "double", "double", "double" },
                new[] { "dvec2", "dvec2", "dvec2", "dvec2" },
                new[] { "dvec3", "dvec3", "dvec3", "dvec3" },
                new[] { "dvec4", "dvec4", "dvec4", "dvec4" },
                new[] { "dvec2", "dvec2", "double", "double" },
                new[] { "dvec3", "dvec3", "double", "double" },
                new[] { "dvec4", "dvec4", "double", "double" },
                new[] { "int", "int", "int", "int" },
                new[] { "ivec2", "ivec2", "ivec2", "ivec2" },
                new[] { "ivec3", "ivec3", "ivec3", "ivec3" },
                new[] { "ivec4", "ivec4", "ivec4", "ivec4" },
                new[] { "ivec2", "ivec2", "int", "int" },
                new[] { "ivec3", "ivec3", "int", "int" },
                new[] { "ivec4", "ivec4", "int", "int" },
                new[] { "uint", "uint", "uint", "uint" },
                new[] { "uvec2", "uvec2", "uvec2", "uvec2" },
                new[] { "uvec3", "uvec3", "uvec3", "uvec3" },
                new[] { "uvec4", "uvec4", "uvec4", "uvec4" },
                new[] { "uvec2", "uvec2", "uint", "uint" },
                new[] { "uvec3", "uvec3", "uint", "uint" },
                new[] { "uvec4", "uvec4", "uint", "uint" },
            })
        {
        }
    }
}
