﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectDefinitions;
using ShaderGenerator.GLSL;

namespace EffectCombiner.Primitives.Generation.AutoGen.Operators
{
    public class AbsOperatorDefinitionSet : IAutoDefinitionSet
    {
        private static string MakeShaderCodeScalar( string funcName, string type, string paramName )
        {
            var sb = new StringBuilder();
            sb.AppendLine(string.Format("{0} {1}( {0} {2} )", type, funcName, paramName));
            sb.AppendLine("{");
            sb.AppendLine(string.Format("    return abs( {0} );", paramName));
            sb.AppendLine("}");

            return sb.ToString();
        }
        private static string MakeShaderCodeVector2(string funcName, string type, string paramName)
        {
            var sb = new StringBuilder();
            sb.AppendLine(string.Format("{0} {1}( {0} {2} )", type, funcName, paramName));
            sb.AppendLine("{");
            sb.AppendLine(string.Format("    return {0}( abs( {1}.x ), abs( {1}.y ) );", type, paramName));
            sb.AppendLine("}");

            return sb.ToString();
        }
        private static string MakeShaderCodeVector3(string funcName, string type, string paramName)
        {
            var sb = new StringBuilder();
            sb.AppendLine(string.Format("{0} {1}( {0} {2} )", type, funcName, paramName));
            sb.AppendLine("{");
            sb.AppendLine(string.Format("    return {0}( abs( {1}.x ), abs( {1}.y ), abs( {1}.z ) );", type, paramName));
            sb.AppendLine("}");

            return sb.ToString();
        }
        private static string MakeShaderCodeVector4(string funcName, string type, string paramName)
        {
            var sb = new StringBuilder();
            sb.AppendLine(string.Format("{0} {1}( {0} {2} )", type, funcName, paramName));
            sb.AppendLine("{");
            sb.AppendLine(string.Format("    return {0}( abs( {1}.x ), abs( {1}.y ), abs( {1}.z ), abs( {1}.w ) );", type, paramName));
            sb.AppendLine("}");

            return sb.ToString();
        }

        public AbsOperatorDefinitionSet()
        {
            var paramNames = new[] { "x" };
            var supportedFunctionPrototypes = new[]
            {
                // 返り値, 引数1, 引数2, ...
                new[] { "int", "int" },
                new[] { "uint", "uint" },
                new[] { "float", "float" },
                new[] { "double", "double" },
                new[] { "vec2", "vec2" },
                new[] { "vec3", "vec3" },
                new[] { "vec4", "vec4" },
            };

            FunctionDefinitions = OperatorDefinitionSetUtility.CreateFunctions(this, supportedFunctionPrototypes, paramNames);
            BlockDefinition = new PolymorphicBlockDefinition(BlockName, Guid, FunctionDefinitions);

            ShaderCodes = new[]
            {
                MakeShaderCodeScalar( FunctionName, "int", paramNames[ 0 ] ),       // int
                MakeShaderCodeScalar( FunctionName, "uint", paramNames[ 0 ] ),      // uint
                MakeShaderCodeScalar( FunctionName, "float", paramNames[ 0 ] ),     // float
                MakeShaderCodeScalar( FunctionName, "double", paramNames[ 0 ] ),    // double
                MakeShaderCodeVector2( FunctionName, "vec2", paramNames[ 0 ] ),     // vec2
                MakeShaderCodeVector3( FunctionName, "vec3", paramNames[ 0 ] ),     // vec3
                MakeShaderCodeVector4( FunctionName, "vec4", paramNames[ 0 ] ),     // vec4
            };
        }

        public string Guid
        {
            get { return "{CE1D2258-46A6-42EC-B4D7-4B8221007BD5}"; }
        }

        public string FunctionName
        {
            get { return "Abs"; }
        }

        public string BlockName
        {
            get { return "Abs"; }
        }

        public FunctionDefinition[] FunctionDefinitions { get; private set; }
        public PolymorphicBlockDefinition BlockDefinition { get; private set; }
        public string[] ShaderCodes { get; private set; }
    }
}
