﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Text;
using EffectCombiner.Core;

namespace EffectCombiner.Generator
{
    public class PathContainer
    {
        private readonly List<PathLookupInfo> paths = new List<PathLookupInfo>();
        public IEnumerable<PathLookupInfo> Paths { get; private set; }

        public PathContainer()
        {
            Paths = new ReadOnlyCollection<PathLookupInfo>(paths);
        }

        public void Add(PathLookupInfo pathInfo)
        {
            if (string.IsNullOrWhiteSpace(pathInfo.Path))
                throw new ArgumentException("Invalid 'pathInfo' argument, 'Path' member is invalid.", "pathInfo");

            paths.Add(pathInfo);
        }

        public void Add(string path, SearchOption searchOption, params string[] patterns)
        {
            if (string.IsNullOrWhiteSpace(path))
                throw new ArgumentException("Invalid 'path' argument.", "path");

            paths.Add(new PathLookupInfo(path, searchOption == SearchOption.AllDirectories, patterns));
        }

        public void Clear()
        {
            paths.Clear();
        }
    }
}
