﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Threading;

namespace EffectCombiner.Editor.Log
{
    /// <summary>
    /// ログハンドラのインターフェースです。
    /// </summary>
    public interface ILogHandler
    {
        /// <summary>
        /// ログハンドラの名前を取得します。
        /// </summary>
        string LogHandlerName { get; }

        #if false
        /// <summary>
        /// ログハンドラの同期コンテキストを取得します。
        /// </summary>
        SynchronizationContext SynchronizationContext { get; }
        #endif

        /// <summary>
        /// ロガーからメッセージが送られたときの処理を行います。
        /// </summary>
        /// <param name="destinations">ログ出力先</param>
        /// <param name="level">ログレベル</param>
        /// <param name="message">ログメッセージ</param>
        /// <param name="callStack">コールスタック</param>
        void Log(IEnumerable<string> destinations, LogLevels level, string message, StackFrame callStack);
    }
}
