﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Xml.Serialization;

namespace EffectCombiner.Data.Processors.Version2
{
    [Serializable]
    public class ConstInfoV2
    {
        [XmlAttribute("type")]
        public string Type;
        [XmlAttribute("values")]
        public string Values;
    }

    [Serializable]
    public class BlockV2
    {
        [XmlAttribute("id")]
        public string Identifier;
        [XmlAttribute("guid")]
        public string BlockGuid;
        [XmlAttribute("x")]
        public float PositionX;
        [XmlAttribute("y")]
        public float PositionY;
        [XmlAttribute("w")]
        public float SizeW;
        [XmlAttribute("h")]
        public float SizeH;
        [XmlElement("const")]
        public ConstInfoV2 ConstInfo;
    }

    [Serializable]
    public class BlocksV2
    {
        [XmlElement("block")]
        public BlockV2[] Block;
    }

    [Serializable]
    public class BlockReferenceV2
    {
        [XmlAttribute("block")]
        public string BlockIdentifier;
        [XmlAttribute("index")]
        public int PlugIndex;
    }

    [Serializable]
    public class ConnectionV2
    {
        [XmlElement("source")]
        public BlockReferenceV2 Source;
        [XmlElement("target")]
        public BlockReferenceV2 Target;
    }

    [Serializable]
    public class ConnectionsV2
    {
        [XmlElement("connection")]
        public ConnectionV2[] Connection;
    }

    [Serializable, XmlRoot("project")]
    public class ProjectV2
    {
        [XmlAttribute("version")]
        public ushort Version;
        [XmlAttribute("x")]
        public float WorkspacePositionX;
        [XmlAttribute("y")]
        public float WorkspacePositionY;
        [XmlElement("blocks")]
        public BlocksV2 Blocks;
        [XmlElement("connections")]
        public ConnectionsV2 Connections;
        [XmlElement("uniforms")]
        public UniformsV2 Uniforms;
    }

    [Serializable]
    public class UniformsV2
    {
        [XmlElement("uniform")]
        public UniformV2[] Uniform;
    }

    [Serializable]
    public class UniformV2
    {
        [XmlAttribute("name")]
        public string Name;
        [XmlAttribute("type")]
        public string Type;
        [XmlAttribute("values")]
        public string Values;
    }
}
