﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// Globals

//=============================================================================
// include
//=============================================================================
#include "../NintendoFtx/NpsCommon.h"
#include "NpsSlice.h"

#include "PIExport.h"

//=============================================================================
// constants
//=============================================================================

//-----------------------------------------------------------------------------
// plugin name & help
#define NPS_PLUGIN_NAME "NintendoSliceInfo"
#define NPS_PLUGIN_DESCRIPTION "Slice Information Export Plugin"
#define NPS_PLUGIN_HELP_URL "NintendoSliceInfo.html"

//=============================================================================
//! @brief グローバルデータのクラスです。
//=============================================================================
class Globals
{
  public:
    // export common
    int16* result;                  // Must always be first in Globals.
    ExportRecord* exportParamBlock; // Must always be second in Globals.
    Boolean queryForParameters;

  public:
    //! 初期化します。
    void Init()
    {
        queryForParameters = true;
    }

    //! 解放します。
    void Free()
    {
    }
};

typedef Globals* GPtr;
typedef Globals** GHdl;

// export common
#define gResult (*(globals->result))       // SDK のマクロのため、かならず gResult という名前で定義します。
#define gStuff (globals->exportParamBlock) // SDK のマクロのため、かならず gStuff  という名前で定義します。
#define gQueryForParameters (globals->queryForParameters)

