﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/******************************************************************************
    include
******************************************************************************/
#include "DccUtilityCommon.h"
#include "DccUtilityLight.h"


/******************************************************************************
    begin name space utility
******************************************************************************/
namespace nn {
namespace gfx {
namespace tool {
namespace dcc {
namespace utility {


/*-----------------------------------------------------------------------*
  @brief シーンに存在する複数のライトを扱うためのクラスです。
  　シーンのエクスポート時に RSceneLights のインスタンスを作成し、
  全てのライトの管理と <Lights> タグを出力します。
  DCCツールのエキスポータプラグインはライトのエキスポートにこのクラスを利用できます。
 *-----------------------------------------------------------------------*/
class RSceneLights
{
public:
    //! コンストラクタです。
    RSceneLights(void);

    //! デストラクタです。
    ~RSceneLights(void);

    //! クラスを初期化します。
    void init(void);


    //! @brief RLight を取得します。
    //! RLightを新規作成して返します。
    //! @return RLight のポインタ
    RLight* GetRLight();

    //! @brief RLightの数を返します。
    //! 登録されたRLightの数を返します。
    //! @return 登録されたRLightの数です。
    const int GetNumRLight(void) const { return static_cast<const int>(mRLights.size()); }

    //! シーン全体の拡大・縮小率を設定する
    void SetMagnify(float magnify)
    {
        RLight::SetMagnify( magnify );
    }

    //!	@brief ライトアニメーションの出力準備をします。
    //!	OutAnims を呼ぶ前に一度呼び出す必要があります。
    void PrepareAnimations( const nn::gfx::tool::dcc::RExpOpt& rOpt );

    //! @brief 中間フォーマットの<CameraAnimationData>タグを出力します。
    //! これはシーン内で使われているすべてのカメラアニメーションを出力する処理です。
    //! カメラアニメーションがひとつもない場合はタグが出力されません。
    //! @param[in] os 出力ストリーム
    //! @param[in] tabSize <Cameras> 要素のインデントに必要なタブの数
    void OutAnims( std::ostream& os, nn::gfx::tool::dcc::RDataStreamArray& dataStreams, const nn::gfx::tool::dcc::RExpOpt& rOpt ) const;

private:
    //! RLightのポインタ配列の型
    typedef std::vector<utility::RLight*> RLightArray;
    //! RLightのポインタ配列の型
    RLightArray mRLights;
};

/******************************************************************************
    end name space utility
******************************************************************************/
}}}}} // namespace utility
