﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/******************************************************************************
    include
******************************************************************************/
#include "DccUtilityCommon.h"
#include "DccUtilityCamera.h"


/******************************************************************************
    begin name space utility
******************************************************************************/
namespace nn {
namespace gfx {
namespace tool {
namespace dcc {
namespace utility {


/*-----------------------------------------------------------------------*
  @brief シーンに存在する複数のカメラを扱うためのクラスです。
  　シーンのエクスポート時に RSceneCameras のインスタンスを作成し、
  全てのカメラの管理と <Cameras> <Camera> タグを出力します。
  DCCツールのエキスポータプラグインはカメラのエキスポートにこのクラスを利用できます。
 *-----------------------------------------------------------------------*/
class RSceneCameras
{
public:
    //! コンストラクタです。
    RSceneCameras(void);

    //! デストラクタです。
    ~RSceneCameras(void);

    //! クラスを初期化します。
    void init(void);


    //! @brief RCamera を取得します。
    //! RCameraを新規作成して返します。
    //! @return RCamera のポインタ
    RCamera* GetRCamera();

    //! シーン全体の拡大・縮小率を設定する
    void SetMagnify(float magnify)
    {
        RCamera::SetMagnify(magnify);
    }

    //!	@brief カメラアニメーションの出力準備をします。
    //!	OutAnims を呼ぶ前に一度呼び出す必要があります。
    //!	@param[in] frameSize アニメーションの総フレーム数
    //!	@param[in] loop ループ再生フラグ
    //!	@param[in] toleranceTrans 移動アニメーションの許容誤差
    //!	@param[in] toleranceRotate 回転アニメーションの許容誤差
    //!	@param[in] toleranceScale スケールアニメーションの許容誤差
    void PrepareAnimations( const nn::gfx::tool::dcc::RExpOpt& rOpt );

    //! @brief 中間フォーマットの<CameraAnimationData>タグを出力します。
    //! これはシーン内で使われているすべてのカメラアニメーションを出力する処理です。
    //! カメラアニメーションがひとつもない場合はタグが出力されません。
    //! @param[in] os 出力ストリーム
    //! @param[in] tabSize <Cameras> 要素のインデントに必要なタブの数
    void OutAnims(std::ostream& os, nn::gfx::tool::dcc::RDataStreamArray& dataStreams, const nn::gfx::tool::dcc::RExpOpt& rOpt) const;


private:
    //! RCameraのポインタ配列の型
    typedef std::vector<RCamera*> RCameraArray;
    //! RCameraのポインタ配列の型
    RCameraArray mRCameras;
};

/******************************************************************************
    end name space utility
******************************************************************************/
}}}}} // namespace utility
