﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// SetTextureCombiners SetAlphaAndFragmentOperation
// SetSpecularLut SetAnisotropicAzimuthLut

// RRasterization
// RTexCoordinator RTexMapper
// RFragmentShader RFragmentBump RFragmentLighting RLutSampler RLutImage
// RTexCombiner RAlphaTest
// RDepthOperation RBlendOperation RStencilOperation
// RMaterial

/******************************************************************************
    switch
******************************************************************************/

/******************************************************************************
    include
******************************************************************************/
#include "DccUtilityMaterial.h"

using namespace std;
namespace Dcc = nn::gfx::tool::dcc;

/******************************************************************************
    begin name space utility
******************************************************************************/
namespace nn {
namespace gfx {
namespace tool {
namespace dcc {
namespace utility {

// マテリアルがテクスチャパターンアニメーションを持っているかチェックします。
bool FMaterial::IsContainingTexPatAnimData( void ) const
{
    //-----------------------------------------------------------------------------
    // loop for sampler
    for (int iSampler = 0; iSampler < static_cast<int>(m_Samplers.size()); ++iSampler)
    {
        const Dcc::RSampler& sampler = m_Samplers[iSampler];
        if (sampler.m_TexPatAnimIndex != -1)
        {
            return true;
        }
    }

    return false;
}

// マテリアルがテクスチャパターンアニメーションを持っているかチェックします。
bool FMaterial::IsContainingTexSRTAnimData( void ) const
{
    //-----------------------------------------------------------------------------
    // loop for sampler
    for (int iSampler = 0; iSampler < static_cast<int>(m_Samplers.size()); ++iSampler)
    {
        const Dcc::RSampler& sampler = m_Samplers[iSampler];
        if (sampler.m_TexSrtAnimIndex != -1)
        {
            return true;
        }
    }

    return false;
}

// マテリアルがカラーアニメーションを持っているかチェックします。
bool FMaterial::IsContainingColorAnimData( void ) const
{
    //-----------------------------------------------------------------------------
    // loop for color
    for (int paramIdx = 0; paramIdx < RMaterial::COLOR_PARAM_COUNT; ++paramIdx)
    {
        if (m_Anims[paramIdx].m_UseFlag)
        {
            return true;
        }
    }

    return false;
}

void FMaterial::PrepareAnimations( const Dcc::RExpOpt& rOpt )
{
    // アニメーションフラグを設定する
    for(int i = 0; i < RMaterial::COLOR_PARAM_COUNT; i++)
    {
        Dcc::RAnimCurve& curve = m_Anims[i];

        //	最終的に出力されるキーが空の場合のみ更新する。
        //	キーフレーム出力の場合はすでにこの段階でキーのリストが作成済みの状態となる。
        if( curve.m_Keys.size() == 0 )
        {
            // 値が設定されていたら常にアニメーションを出力する
            if (curve.m_FullValues.size() > 0)
            {
                curve.m_LoopFlag = rOpt.m_LoopAnim;
                curve.m_Tolerance = rOpt.m_TolC;// * ( 1.0f / 255.0f);
                curve.m_UseFlag = true;
                curve.UpdateConstantFlag();
                if(!curve.m_ConstantFlag)
                {
                    curve.MakeKeys(GetFloatFrameFromSubFrame4f, nullptr, false);
                }
            }
            else
            {
                curve.m_UseFlag = false;
                curve.m_ConstantFlag = true;
            }
        }
    }
}

//-----------------------------------------------------------------------------
//! @brief マテリアルのカラーアニメーション配列を出力します。
//!
//! @param[in,out] os 出力ストリームです。
//! @param[in,out] dataStreams データ列配列です。
//! @param[in] tc カラーアニメーション配列要素のインデントに必要なタブの数です。
//-----------------------------------------------------------------------------
void FMaterial::OutputColorAnims(std::ostream& os, Dcc::RDataStreamArray& dataStreams, const int tc) const
{
    const int RGB_COUNT = 3;
    static const char* const hintStrs[] =
    {
        "diffuse" ,
        "opacity" ,
        "ambient" ,
        "emission",
        "specular"
    };
    static const char* const targetStrs[] = { "color_r", "color_g", "color_b" };

    //-----------------------------------------------------------------------------
    // begin original color anim array
    int animatedColorCount = 0;
    for (int paramIdx = 0; paramIdx < Dcc::RMaterial::COLOR_PARAM_COUNT; paramIdx += RGB_COUNT)
    {
        if (m_Anims[paramIdx + 0].m_UseFlag ||
            m_Anims[paramIdx + 1].m_UseFlag ||
            m_Anims[paramIdx + 2].m_UseFlag)
        {
            ++animatedColorCount;
        }
    }
    os << Dcc::RTab(tc) << "<original_color_anim_array length=\"" << animatedColorCount << "\">" << R_ENDL;

    //-----------------------------------------------------------------------------
    // loop for color attr
    int colorAnimIdx = 0;
    for (int paramIdx = 0; paramIdx < Dcc::RMaterial::COLOR_PARAM_COUNT; paramIdx += RGB_COUNT)
    {
        if (m_Anims[paramIdx + 0].m_UseFlag ||
            m_Anims[paramIdx + 1].m_UseFlag ||
            m_Anims[paramIdx + 2].m_UseFlag)
        {
            os << Dcc::RTab(tc + 1) << "<original_color_anim index=\"" << colorAnimIdx
                << "\" hint=\"" << hintStrs[paramIdx / RGB_COUNT]
            << "\">" << R_ENDL;
            for (int rgbIdx = 0; rgbIdx < RGB_COUNT; ++rgbIdx)
            {
                const Dcc::RAnimCurve& curve = m_Anims[paramIdx + rgbIdx];
                if (curve.m_UseFlag)
                {
                    curve.Out(os, dataStreams, tc + 2, "original_color_anim_target",
                        targetStrs[rgbIdx], true);
                }
            }
            os << Dcc::RTab(tc + 1) << "</original_color_anim>" << R_ENDL;
            ++colorAnimIdx;
        }
    }

    //-----------------------------------------------------------------------------
    // end original color anim array
    os << Dcc::RTab(tc) << "</original_color_anim_array>" << R_ENDL;
}


/******************************************************************************
    end name space utility
******************************************************************************/
}}}}} // namespace utility

/******************************************************************************
-------------------------------------------------------------------------------
                end of file
-------------------------------------------------------------------------------
******************************************************************************/
