﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "DccCommon.h"

/******************************************************************************
    include
******************************************************************************/

/******************************************************************************
    begin name space utility
******************************************************************************/
namespace nn {
namespace gfx {
namespace tool {
namespace dcc {
namespace utility {

/******************************************************************************
******************************************************************************/
bool CreateFolderIfNotExist(const std::string& folderPath);
bool RemoveFolderIfExist(const std::string& folderPath);
bool CopyFile(const std::string& srcPath, const std::string& dstPath);

nn::gfx::tool::dcc::RStatus MoveDirectory( const std::string& folderPath, const std::string& outFolderPath );
nn::gfx::tool::dcc::RStringArray GetFileNamesFromFolder( const std::string& path );
bool IsValidPresetNameString( const std::string& name );

/******************************************************************************
    constants
******************************************************************************/

//-----------------------------------------------------------------------------
// file version
extern const char* R_INTERMEDIATE_FILEVERSION;

//-----------------------------------------------------------------------------
// node
extern const char* R_WORLD_ROOT_NAME;

//-----------------------------------------------------------------------------
// output file name
extern const char* R_OUT_FILE_NAME_NODE;

//-----------------------------------------------------------------------------
// NW4C path
extern const char* R_NW4C_ROOT_ENV;
extern const char* R_CREATIVE_STUDIO_FOLDER;
extern const char* R_CREATIVE_STUDIO_STARTER_FOLDER;
extern const char* R_3D_EDITOR_FOLDER;
extern const char* R_CREATIVE_STUDIO_EXE;
extern const char* R_3D_EDITOR_STARTER_EXE;
extern const char* R_3D_EDITOR_EXE;

//-----------------------------------------------------------------------------
// enviroment
extern const char* R_ENV_USE_NON_UNIFORM_SCALE;

//-----------------------------------------------------------------------------
// NW4C library
const int R_RENDER_PRIORITY_MAX = 255;

/******************************************************************************
    end name space utility
******************************************************************************/
}}}}} // namespace utility
