﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NintendoExportMax.h"

namespace Dcc = nn::gfx::tool::dcc;
using namespace nn::gfx::tool::dcc::utility;

extern std::string GetNintendoRootPath(void);
extern std::string Get3dCommandLineToolsPath(void);


// maxのindexは1スタートなので、変換する
int MaxIdxToIdx(int max_idx)
{
    return max_idx - 1;
}
int IdxToMaxIdx(int idx)
{
    return idx + 1;
}


/*

int QuantTypeToInt(Dcc::RExpOpt::Quantize q)
{
    return q + 1;
}
Dcc::RExpOpt::Quantize IntToQuantType(int q)
{
    return q - 1;
}
*/
IParamBlock2* NintendoOptions::GetNw4fCustAttribParam(void)
{
    // custom attrib
    INode* root = GetCOREInterface()->GetRootNode();
    ICustAttribContainer* cc = root->GetCustAttribContainer();
    if(!cc)
    {
        root->AllocCustAttribContainer();
        cc = root->GetCustAttribContainer();
    }
    if(!cc)
    {
        //多分ここには来ないはず
        return NULL;
    }

    CustAttrib* attrib = NULL;
    // すでにNw4fCustAttribが存在すればそれを返す
    for(int i = 0; i < cc->GetNumCustAttribs(); i++)
    {
        if(cc->GetCustAttrib(i)->ClassID() == NINTENDOEXPORT_ATTRIB_CLASS_ID)
        {
            attrib = cc->GetCustAttrib(i);
            break;
        }
    }
    // Nw4fCustAttribが無ければ作成して返す
    if(!attrib)
    {
        attrib = new NintendoCustAttrib;
        cc->AppendCustAttrib(attrib);
        // 初期値に設定するために、初期化とセーブを行う
        // ^-初期値にリセットは行わないように変更
        //Init();
        SaveToAttribute();
    }

    return attrib->GetParamBlock(0);
}

void NintendoOptions::InitConfigOptions()
{
    //-----------------------------------------------------------------------------
    // コンフィグファイルで指定するオプション
    m_Opt.m_DisplaysProfile = false;
    m_Opt.m_ProjectRootPath = "";
    m_Opt.m_MaxVertexSkinningCount = Dcc::RExpOpt::VERTEX_SKINNING_COUNT_MAX;
    m_Opt.m_AdjustsSmoothSkinning = false;
    m_Opt.m_CompressesIgnoringVertexSkinningCount = false;
    m_Opt.m_OptimizePrimitive = Dcc::RExpOpt::OPTIMIZE_PRIMITIVE_FORSYTH;
    m_Opt.m_QuantizationAnalysis = true;
    m_Opt.m_UsesSrgbFetch = true;
    m_Opt.m_EnablesWeightedCompress = false;
    m_Opt.m_IsFilterMipLinear = true;
    m_Opt.m_UsesFclFtsFtp = true;
    m_Opt.m_SeparatesFma = false;
    m_Opt.m_BoneVisMergePriority = false;
    m_Opt.m_ExportsBoneVisAll = true;
    m_Opt.m_WarnsNodeNameChanged = true;
}

void NintendoOptions::Init( void )
{
    m_OptionVersion = 0;
    m_DisableZYAxisConversion = false;

    // preset
    m_Opt.m_PresetName = "";
    m_Opt.m_PresetFilePath = "";
    m_showPresetUI = true;

    // Output Options
    m_Opt.m_AnimRangeFlag = false;
    m_Opt.m_Target = Dcc::RExpOpt::EXPORT_TARGET_ALL;
    m_Opt.m_ModelName = "";
    m_Opt.m_OutFileName = "";
    m_Opt.m_OutFolderPath = "";


    // Merge Options
    m_Opt.m_MergeFmdFlag = false;
    m_Opt.m_MergeFmdPath = "";
    //m_Opt.m_AutoMerge = true;
    m_Opt.m_MergeFtxFlag = false;
    m_Opt.m_MergeAnimFlag = false;
    m_Opt.m_MergeAnimFolder = "";
    m_Opt.m_MergeAnimName = "";

    // General Options
    m_Opt.m_Magnify = 1.0f;
    m_Opt.m_TexSrtMode = Dcc::RExpOpt::TEX_SRT_MODE_3DSMAX;
    m_Opt.m_RemoveNamespace = false;
    m_UseFigureMode = false;
    m_Opt.m_CommentText = "";

    // Output File Selection
    m_Opt.m_IsBinaryFormat = true;
    m_Opt.ClearOutFileFlag();
    m_Opt.m_OutFileFlag[Dcc::RExpOpt::FMD] = true;
    m_Opt.m_OutFtxFlag = true;

    // internal
    m_Opt.ClearNoAnimWarnedFlag();

    // Optimization Options
    m_Opt.InitOptimization();

    // Quantization Options
    /*
    m_Opt.m_QuantPos = Dcc::RExpOpt::QuantizeFloat;
    m_Opt.m_QuantNrm = Dcc::RExpOpt::QuantizeFloat;
    m_Opt.m_QuantTex = Dcc::RExpOpt::QuantizeFloat;
    */
    //useUnifiedQuantizeScale = false;

    // Model Options
    //nonUniformScale = false;
    //reservedUniform = 0;
    //doesBindByName = true;
    //skinningMode = 1;

    // Animation Options
    m_Opt.m_FrameRange = Dcc::RExpOpt::FRAME_RANGE_ALL;
    m_Opt.m_StartFrame = 0;
    m_Opt.m_EndFrame = 100;
    m_Opt.m_FramePrecision = 1;
    m_Opt.m_LoopAnim = false;
    //isFrameFormat = false;
    //scaleQuality = rotateQuality = transQuality = 9;

    // Bake Tolerance Options
    m_Opt.m_TolT = 0.01f;
    m_Opt.m_TolR = 0.1f;
    m_Opt.m_TolS = 0.01f;
    m_Opt.m_TolTexT = 0.01f;
    m_Opt.m_TolTexR = 0.1f;
    m_Opt.m_TolTexS = 0.01f;
    m_Opt.m_TolC = 0.001f;

    //-----------------------------------------------------------------------------
    // quantization tolerance
    //m_Opt.m_QuantTolF = 0.5f;

    m_Opt.m_QuantTolS = 0.01f;
    m_Opt.m_QuantTolR = 0.2f;
    m_Opt.m_QuantTolT = 0.001f;

    m_Opt.m_QuantTolTexS = 0.01f;
    m_Opt.m_QuantTolTexR = 0.2f;
    m_Opt.m_QuantTolTexT = 0.01f;

    // script
    m_Opt.m_PreExpScript = "";
    m_Opt.m_PostExpScript = "";

    InitConfigOptions();
    // lock
    m_Lock_export_target = FALSE;
    m_Lock_output_file_name = FALSE;
    m_Lock_output_folder = FALSE;
    m_Lock_use_figure_mode = FALSE;
    m_Lock_merge_fmd = FALSE;
    m_Lock_merge_ftx = FALSE;
    m_Lock_merge_anim = FALSE;
    m_Lock_merge_anim_name = FALSE;
    m_Lock_magnify = FALSE;
    m_Lock_comment = FALSE;
    m_Lock_frame_range = FALSE;
    m_Lock_loop_anim = FALSE;
    m_Lock_bake_all_anim = FALSE;
    m_Lock_frame_precision = FALSE;
    m_Lock_output_fmd = FALSE;
    m_Lock_output_ftx = FALSE;
    m_Lock_output_fsk = FALSE;
    m_Lock_output_fvb = FALSE;
    m_Lock_output_fcl = FALSE;
    m_Lock_output_fts = FALSE;
    m_Lock_output_ftp = FALSE;
    m_Lock_output_fsh = FALSE;
    m_Lock_output_fsn = FALSE;
    m_Lock_compress_bone = FALSE;
    m_Lock_unite_child = FALSE;
    m_Lock_compress_material = FALSE;
    m_Lock_compress_shape = FALSE;
    m_Lock_tolerance_scale = FALSE;
    m_Lock_tolerance_rotate = FALSE;
    m_Lock_tolerance_translate = FALSE;
    m_Lock_tolerance_color = FALSE;
    m_Lock_tolerance_tex_scale = FALSE;
    m_Lock_tolerance_tex_rotate = FALSE;
    m_Lock_tolerance_tex_translate = FALSE;
    m_Lock_quantize_tolerance_scale = FALSE;
    m_Lock_quantize_tolerance_rotate = FALSE;
    m_Lock_quantize_tolerance_translate = FALSE;
    m_Lock_quantize_tolerance_tex_scale = FALSE;
    m_Lock_quantize_tolerance_tex_rotate = FALSE;
    m_Lock_quantize_tolerance_tex_translate = FALSE;
    m_Lock_pre_export_script = FALSE;
    m_Lock_post_export_script = FALSE;

}

// カスタムアトリビュートから設定値を取得
void NintendoOptions::LoadFromAtribute(void)
{
    IParamBlock2* pblock = GetNw4fCustAttribParam();
    if(!pblock) return;

    m_OptionVersion		= pblock->GetInt(nw4f_p_optionVersion);
    MCHAR* buf;

    m_Opt.m_Target		= (pblock->GetInt(nw4f_p_exportAllNode) == TRUE)?
        Dcc::RExpOpt::EXPORT_TARGET_ALL : Dcc::RExpOpt::EXPORT_TARGET_SELECTION;
    m_Opt.m_OutFolderPath	= (buf = (MCHAR*)pblock->GetStr(nw4f_p_outFolder))? M_2_A(buf): "";
    m_Opt.m_OutFileName	= (buf = (MCHAR*)pblock->GetStr(nw4f_p_outName))? M_2_A(buf): "";

    m_Opt.m_MergeFmdFlag	= pblock->GetInt(nw4f_p_mergeFmdFlag) == TRUE;
    m_Opt.m_MergeFmdPath	= (buf = (MCHAR*)pblock->GetStr(nw4f_p_mergeFmdPath))? M_2_A(buf): "";

    m_Opt.m_MergeFtxFlag = pblock->GetInt(nw4f_p_mergeFtxFlag) == TRUE;
    m_Opt.m_MergeAnimFlag = pblock->GetInt(nw4f_p_mergeAnimFlag) == TRUE;
    m_Opt.m_MergeAnimFolder = (buf = (MCHAR*)pblock->GetStr(nw4f_p_mergeAnimFolder))? M_2_A(buf): "";
    m_Opt.m_MergeAnimName = (buf = (MCHAR*)pblock->GetStr(nw4f_p_mergeAnimName))? M_2_A(buf): "";

    m_Opt.m_Magnify		= pblock->GetFloat(nw4f_p_magnify);
    m_UseFigureMode		= pblock->GetInt(nw4f_p_useFigureMode) == TRUE;
    m_Opt.m_CommentText = (buf = (MCHAR*)pblock->GetStr(nw4f_p_commnetText))? M_2_A(buf): "";

    m_Opt.m_IsBinaryFormat			= true;  // ascii出力モードは廃止

    m_Opt.m_OutFileFlag[Dcc::RExpOpt::FMD]	= pblock->GetInt(nw4f_p_exportModel) == TRUE;
    m_Opt.m_OutFileFlag[Dcc::RExpOpt::FSK] = pblock->GetInt(nw4f_p_exportSkeletalAnim) == TRUE;
    m_Opt.m_OutFileFlag[Dcc::RExpOpt::FVB] = pblock->GetInt(nw4f_p_exportBoneVisAnim) == TRUE;
    m_Opt.m_OutFileFlag[Dcc::RExpOpt::FCL] = pblock->GetInt(nw4f_p_exportMtlColAnim) == TRUE;
    m_Opt.m_OutFileFlag[Dcc::RExpOpt::FTS] = pblock->GetInt(nw4f_p_exportMtlTexSRTAnim) == TRUE;
    m_Opt.m_OutFileFlag[Dcc::RExpOpt::FTP] = pblock->GetInt(nw4f_p_exportMtlTexPatAnim) == TRUE;
    m_Opt.m_OutFileFlag[Dcc::RExpOpt::FSH] = pblock->GetInt(nw4f_p_exportShapeAnim) == TRUE;

    //m_Opt.m_OutFileFlag[Dcc::RExpOpt::Fcm] = pblock->GetInt(nw4f_p_exportCam) == TRUE;
    //m_Opt.m_OutFileFlag[Dcc::RExpOpt::Flt] = pblock->GetInt(nw4f_p_exportLight) == TRUE;
    m_Opt.m_OutFileFlag[Dcc::RExpOpt::FSN] = pblock->GetInt(nw4f_p_exportSceneAnim) == TRUE;
    //m_Opt.m_OutFileFlag[Dcc::RExpOpt::Fen] = pblock->GetInt(nw4f_p_exportEnv) == TRUE;

    m_Opt.m_OutFtxFlag				= pblock->GetInt(nw4f_p_exportTex) == TRUE;

    m_Opt.m_CompressBone		= (Dcc::RExpOpt::CompressBone)pblock->GetInt(nw4f_p_compressBoneMode);

    m_Opt.m_UniteChild			= pblock->GetInt(nw4f_p_uniteChild) == TRUE;
    m_Opt.m_CompressMaterial		= pblock->GetInt(nw4f_p_compressMtl) == TRUE;
    m_Opt.m_CompressShape			= pblock->GetInt(nw4f_p_compressShape) == TRUE;
    //	TODO:
    //	m_Opt.m_OptimizePrimitive		= pblock->GetInt(nw4f_p_optimizePrim) == TRUE;
    m_Opt.m_OptimizePrimitive		= Dcc::RExpOpt::OPTIMIZE_PRIMITIVE_FORSYTH;
    m_Opt.m_QuantizationAnalysis	= pblock->GetInt(nw4f_p_quantizationAnalysis) == TRUE;

    /*
    m_Opt.m_QuantPos			= (Dcc::RExpOpt::Quantize)pblock->GetInt(nw4f_p_quantPos);
    m_Opt.m_QuantNrm			= (Dcc::RExpOpt::Quantize)pblock->GetInt(nw4f_p_quantNormal);
    m_Opt.m_QuantTex			= (Dcc::RExpOpt::Quantize)pblock->GetInt(nw4f_p_quantTex);
    */

    m_Opt.m_FrameRange	= (pblock->GetInt(nw4f_p_exportAllFrames) == TRUE)?
        Dcc::RExpOpt::FRAME_RANGE_ALL : Dcc::RExpOpt::FRAME_RANGE_SPECIFY;
    m_Opt.m_StartFrame	= pblock->GetInt(nw4f_p_startFrame);
    m_Opt.m_EndFrame		= pblock->GetInt(nw4f_p_endFrame);
    m_Opt.m_FramePrecision	= pblock->GetInt(nw4f_p_framePrecision);
    m_Opt.m_LoopAnim			= pblock->GetInt(nw4f_p_isLoop) == TRUE;

    m_Opt.m_TolT		= pblock->GetFloat(nw4f_p_toleranceTrans);
    m_Opt.m_TolR		= pblock->GetFloat(nw4f_p_toleranceRotate);
    m_Opt.m_TolS		= pblock->GetFloat(nw4f_p_toleranceScale);
    m_Opt.m_TolTexT	= pblock->GetFloat(nw4f_p_toleranceUVTrans);
    m_Opt.m_TolTexR	= pblock->GetFloat(nw4f_p_toleranceUVRotate);
    m_Opt.m_TolTexS	= pblock->GetFloat(nw4f_p_toleranceUVScale);
    m_Opt.m_TolC		= pblock->GetFloat(nw4f_p_toleranceColor);

    m_Opt.m_QuantTolT		= pblock->GetFloat(nw4f_p_quantToleranceTrans);
    m_Opt.m_QuantTolR		= pblock->GetFloat(nw4f_p_quantToleranceRotate);
    m_Opt.m_QuantTolS		= pblock->GetFloat(nw4f_p_quantToleranceScale);
    m_Opt.m_QuantTolTexT	= pblock->GetFloat(nw4f_p_quantToleranceUVTrans);
    m_Opt.m_QuantTolTexR	= pblock->GetFloat(nw4f_p_quantToleranceUVRotate);
    m_Opt.m_QuantTolTexS	= pblock->GetFloat(nw4f_p_quantToleranceUVScale);
    //m_Opt.m_QuantTolF		= pblock->GetFloat(nw4f_p_quantToleranceFrame);

    m_DisableZYAxisConversion		= (pblock->GetInt(nw4f_p_disableZYAxisConversion) == TRUE);

    //script
    m_Opt.m_PreExpScript = (buf = (MCHAR*)pblock->GetStr(nw4f_p_preExportScript))? M_2_A(buf): "";
    m_Opt.m_PostExpScript = (buf = (MCHAR*)pblock->GetStr(nw4f_p_postExportScript))? M_2_A(buf): "";

    // lock
    m_Lock_export_target = pblock->GetInt(nw4f_p_lock_export_target);
    m_Lock_output_file_name = pblock->GetInt(nw4f_p_lock_output_file_name);
    m_Lock_output_folder = pblock->GetInt(nw4f_p_lock_output_folder);
    m_Lock_use_figure_mode = pblock->GetInt(nw4f_p_lock_use_figure_mode);
    m_Lock_merge_fmd = pblock->GetInt(nw4f_p_lock_merge_fmd);
    m_Lock_merge_ftx = pblock->GetInt(nw4f_p_lock_merge_ftx);
    m_Lock_merge_anim = pblock->GetInt(nw4f_p_lock_merge_anim);
    m_Lock_merge_anim_name = pblock->GetInt(nw4f_p_lock_merge_anim_name);
    m_Lock_magnify = pblock->GetInt(nw4f_p_lock_magnify);
    m_Lock_comment = pblock->GetInt(nw4f_p_lock_comment);
    m_Lock_frame_range = pblock->GetInt(nw4f_p_lock_frame_range);
    m_Lock_loop_anim = pblock->GetInt(nw4f_p_lock_loop_anim);
    m_Lock_bake_all_anim = pblock->GetInt(nw4f_p_lock_bake_all_anim);
    m_Lock_frame_precision = pblock->GetInt(nw4f_p_lock_frame_precision);
    m_Lock_output_fmd = pblock->GetInt(nw4f_p_lock_output_fmd);
    m_Lock_output_ftx = pblock->GetInt(nw4f_p_lock_output_ftx);
    m_Lock_output_fsk = pblock->GetInt(nw4f_p_lock_output_fsk);
    m_Lock_output_fvb = pblock->GetInt(nw4f_p_lock_output_fvb);
    m_Lock_output_fcl = pblock->GetInt(nw4f_p_lock_output_fcl);
    m_Lock_output_fts = pblock->GetInt(nw4f_p_lock_output_fts);
    m_Lock_output_ftp = pblock->GetInt(nw4f_p_lock_output_ftp);
    m_Lock_output_fsh = pblock->GetInt(nw4f_p_lock_output_fsh);
    m_Lock_output_fsn = pblock->GetInt(nw4f_p_lock_output_fsn);
    m_Lock_compress_bone = pblock->GetInt(nw4f_p_lock_compress_bone);
    m_Lock_unite_child = pblock->GetInt(nw4f_p_lock_unite_child);
    m_Lock_compress_material = pblock->GetInt(nw4f_p_lock_compress_material);
    m_Lock_compress_shape = pblock->GetInt(nw4f_p_lock_compress_shape);
    m_Lock_tolerance_scale = pblock->GetInt(nw4f_p_lock_tolerance_scale);
    m_Lock_tolerance_rotate = pblock->GetInt(nw4f_p_lock_tolerance_rotate);
    m_Lock_tolerance_translate = pblock->GetInt(nw4f_p_lock_tolerance_translate);
    m_Lock_tolerance_color = pblock->GetInt(nw4f_p_lock_tolerance_color);
    m_Lock_tolerance_tex_scale = pblock->GetInt(nw4f_p_lock_tolerance_tex_scale);
    m_Lock_tolerance_tex_rotate = pblock->GetInt(nw4f_p_lock_tolerance_tex_rotate);
    m_Lock_tolerance_tex_translate = pblock->GetInt(nw4f_p_lock_tolerance_tex_translate);
    m_Lock_quantize_tolerance_scale = pblock->GetInt(nw4f_p_lock_quantize_tolerance_scale);
    m_Lock_quantize_tolerance_rotate = pblock->GetInt(nw4f_p_lock_quantize_tolerance_rotate);
    m_Lock_quantize_tolerance_translate = pblock->GetInt(nw4f_p_lock_quantize_tolerance_translate);
    m_Lock_quantize_tolerance_tex_scale = pblock->GetInt(nw4f_p_lock_quantize_tolerance_tex_scale);
    m_Lock_quantize_tolerance_tex_rotate = pblock->GetInt(nw4f_p_lock_quantize_tolerance_tex_rotate);
    m_Lock_quantize_tolerance_tex_translate = pblock->GetInt(nw4f_p_lock_quantize_tolerance_tex_translate);
    m_Lock_pre_export_script = pblock->GetInt(nw4f_p_lock_pre_export_script);
    m_Lock_post_export_script = pblock->GetInt(nw4f_p_lock_post_export_script);



}

// カスタムアトリビュートに設定値を保存
void NintendoOptions::SaveToAttribute(void)
{
    IParamBlock2* pblock = GetNw4fCustAttribParam();
    if(!pblock) return;

    pblock->SetValue(nw4f_p_optionVersion, 0, NINTENDOEXPORT_VERSION);

    pblock->SetValue(nw4f_p_presetName, 0, A_2_M(m_Opt.m_PresetName.c_str()));
    pblock->SetValue(nw4f_p_presetFile, 0, A_2_M(m_Opt.m_PresetFilePath.c_str()));
    pblock->SetValue(nw4f_p_showPresetUI, 0, m_showPresetUI);

    pblock->SetValue(nw4f_p_exportAllNode, 0, m_Opt.m_Target == Dcc::RExpOpt::EXPORT_TARGET_ALL);
    pblock->SetValue(nw4f_p_outFolder, 0, A_2_M(m_Opt.m_OutFolderPath.c_str()));
    pblock->SetValue(nw4f_p_outName, 0, A_2_M(m_Opt.m_OutFileName.c_str()));

    pblock->SetValue(nw4f_p_mergeFmdFlag, 0, m_Opt.m_MergeFmdFlag);
    pblock->SetValue(nw4f_p_mergeFmdPath, 0, A_2_M(m_Opt.m_MergeFmdPath.c_str()));

    pblock->SetValue(nw4f_p_mergeFtxFlag, 0, m_Opt.m_MergeFtxFlag );
    pblock->SetValue(nw4f_p_mergeAnimFlag, 0, m_Opt.m_MergeAnimFlag);
    pblock->SetValue(nw4f_p_mergeAnimFolder, 0, A_2_M(m_Opt.m_MergeAnimFolder.c_str()));
    pblock->SetValue(nw4f_p_mergeAnimName, 0, A_2_M(m_Opt.m_MergeAnimName.c_str()));

    pblock->SetValue(nw4f_p_magnify, 0, (float)m_Opt.m_Magnify);
    pblock->SetValue(nw4f_p_useFigureMode, 0, m_UseFigureMode);
    pblock->SetValue(nw4f_p_commnetText, 0, A_2_M(m_Opt.m_CommentText.c_str()));

    pblock->SetValue(nw4f_p_binaryFormat, 0, TRUE); // asciiモードは廃止

    pblock->SetValue(nw4f_p_exportModel, 0, m_Opt.m_OutFileFlag[Dcc::RExpOpt::FMD]);
    pblock->SetValue(nw4f_p_exportSkeletalAnim, 0, m_Opt.m_OutFileFlag[Dcc::RExpOpt::FSK]);
    pblock->SetValue(nw4f_p_exportBoneVisAnim, 0, m_Opt.m_OutFileFlag[Dcc::RExpOpt::FVB]);
    pblock->SetValue(nw4f_p_exportMtlColAnim,0,m_Opt.m_OutFileFlag[Dcc::RExpOpt::FCL]);
    pblock->SetValue(nw4f_p_exportMtlTexSRTAnim, 0, m_Opt.m_OutFileFlag[Dcc::RExpOpt::FTS]);
    pblock->SetValue(nw4f_p_exportMtlTexPatAnim, 0, m_Opt.m_OutFileFlag[Dcc::RExpOpt::FTP]);
    pblock->SetValue(nw4f_p_exportShapeAnim, 0, m_Opt.m_OutFileFlag[Dcc::RExpOpt::FSH]);

    //pblock->SetValue(nw4f_p_exportCam, 0, m_Opt.m_OutFileFlag[Dcc::RExpOpt::Fcm]);
    //pblock->SetValue(nw4f_p_exportLight, 0, m_Opt.m_OutFileFlag[Dcc::RExpOpt::Flt]);
    pblock->SetValue(nw4f_p_exportSceneAnim, 0, m_Opt.m_OutFileFlag[Dcc::RExpOpt::FSN]);
    //pblock->SetValue(nw4f_p_exportEnv, 0, m_Opt.m_OutFileFlag[Dcc::RExpOpt::Fen]);

    pblock->SetValue(nw4f_p_exportTex, 0, m_Opt.m_OutFtxFlag);

    pblock->SetValue(nw4f_p_compressBoneMode, 0, m_Opt.m_CompressBone);

    pblock->SetValue(nw4f_p_uniteChild, 0, m_Opt.m_UniteChild);
    pblock->SetValue(nw4f_p_compressMtl, 0, m_Opt.m_CompressMaterial);
    pblock->SetValue(nw4f_p_compressShape, 0, m_Opt.m_CompressShape);
    pblock->SetValue(nw4f_p_optimizePrim, 0, m_Opt.m_OptimizePrimitive);
    pblock->SetValue(nw4f_p_quantizationAnalysis, 0, m_Opt.m_QuantizationAnalysis);


    pblock->SetValue(nw4f_p_exportAllFrames, 0, m_Opt.m_FrameRange == Dcc::RExpOpt::FRAME_RANGE_ALL);
    pblock->SetValue(nw4f_p_startFrame, 0, m_Opt.m_StartFrame);
    pblock->SetValue(nw4f_p_endFrame, 0, m_Opt.m_EndFrame);
    pblock->SetValue(nw4f_p_framePrecision, 0, m_Opt.m_FramePrecision);
    pblock->SetValue(nw4f_p_isLoop, 0, m_Opt.m_LoopAnim);

    pblock->SetValue(nw4f_p_toleranceTrans, 0, m_Opt.m_TolT);
    pblock->SetValue(nw4f_p_toleranceRotate, 0, m_Opt.m_TolR);
    pblock->SetValue(nw4f_p_toleranceScale, 0, m_Opt.m_TolS);
    pblock->SetValue(nw4f_p_toleranceUVTrans, 0, m_Opt.m_TolTexT);
    pblock->SetValue(nw4f_p_toleranceUVRotate, 0, m_Opt.m_TolTexR);
    pblock->SetValue(nw4f_p_toleranceUVScale, 0, m_Opt.m_TolTexS);
    pblock->SetValue(nw4f_p_toleranceColor, 0, m_Opt.m_TolC);

    pblock->SetValue(nw4f_p_quantToleranceTrans, 0, m_Opt.m_QuantTolT);
    pblock->SetValue(nw4f_p_quantToleranceRotate, 0, m_Opt.m_QuantTolR);
    pblock->SetValue(nw4f_p_quantToleranceScale, 0, m_Opt.m_QuantTolS);
    pblock->SetValue(nw4f_p_quantToleranceUVTrans, 0, m_Opt.m_QuantTolTexT);
    pblock->SetValue(nw4f_p_quantToleranceUVRotate, 0, m_Opt.m_QuantTolTexR);
    pblock->SetValue(nw4f_p_quantToleranceUVScale, 0, m_Opt.m_QuantTolTexS);
    //pblock->SetValue(nw4f_p_quantToleranceFrame, 0, m_Opt.m_QuantTolF);

    pblock->SetValue(nw4f_p_disableZYAxisConversion, 0, m_DisableZYAxisConversion);

    //script
    pblock->SetValue(nw4f_p_preExportScript, 0, A_2_M(m_Opt.m_PreExpScript.c_str()));
    pblock->SetValue(nw4f_p_postExportScript, 0, A_2_M(m_Opt.m_PostExpScript.c_str()));

    // lock
    pblock->SetValue(nw4f_p_lock_export_target, 0, m_Lock_export_target);
    pblock->SetValue(nw4f_p_lock_output_file_name, 0, m_Lock_output_file_name);
    pblock->SetValue(nw4f_p_lock_output_folder, 0, m_Lock_output_folder);
    pblock->SetValue(nw4f_p_lock_use_figure_mode, 0, m_Lock_use_figure_mode);
    pblock->SetValue(nw4f_p_lock_merge_fmd, 0, m_Lock_merge_fmd);
    pblock->SetValue(nw4f_p_lock_merge_ftx, 0, m_Lock_merge_ftx);
    pblock->SetValue(nw4f_p_lock_merge_anim, 0, m_Lock_merge_anim);
    pblock->SetValue(nw4f_p_lock_merge_anim_name, 0, m_Lock_merge_anim_name);
    pblock->SetValue(nw4f_p_lock_magnify, 0, m_Lock_magnify);
    pblock->SetValue(nw4f_p_lock_comment, 0, m_Lock_comment);
    pblock->SetValue(nw4f_p_lock_frame_range, 0, m_Lock_frame_range);
    pblock->SetValue(nw4f_p_lock_loop_anim, 0, m_Lock_loop_anim);
    pblock->SetValue(nw4f_p_lock_bake_all_anim, 0, m_Lock_bake_all_anim);
    pblock->SetValue(nw4f_p_lock_frame_precision, 0, m_Lock_frame_precision);
    pblock->SetValue(nw4f_p_lock_output_fmd, 0, m_Lock_output_fmd);
    pblock->SetValue(nw4f_p_lock_output_ftx, 0, m_Lock_output_ftx);
    pblock->SetValue(nw4f_p_lock_output_fsk, 0, m_Lock_output_fsk);
    pblock->SetValue(nw4f_p_lock_output_fvb, 0, m_Lock_output_fvb);
    pblock->SetValue(nw4f_p_lock_output_fcl, 0, m_Lock_output_fcl);
    pblock->SetValue(nw4f_p_lock_output_fts, 0, m_Lock_output_fts);
    pblock->SetValue(nw4f_p_lock_output_ftp, 0, m_Lock_output_ftp);
    pblock->SetValue(nw4f_p_lock_output_fsh, 0, m_Lock_output_fsh);
    pblock->SetValue(nw4f_p_lock_output_fsn, 0, m_Lock_output_fsn);
    pblock->SetValue(nw4f_p_lock_compress_bone, 0, m_Lock_compress_bone);
    pblock->SetValue(nw4f_p_lock_unite_child, 0, m_Lock_unite_child);
    pblock->SetValue(nw4f_p_lock_compress_material, 0, m_Lock_compress_material);
    pblock->SetValue(nw4f_p_lock_compress_shape, 0, m_Lock_compress_shape);
    pblock->SetValue(nw4f_p_lock_tolerance_scale, 0, m_Lock_tolerance_scale);
    pblock->SetValue(nw4f_p_lock_tolerance_rotate, 0, m_Lock_tolerance_rotate);
    pblock->SetValue(nw4f_p_lock_tolerance_translate, 0, m_Lock_tolerance_translate);
    pblock->SetValue(nw4f_p_lock_tolerance_color, 0, m_Lock_tolerance_color);
    pblock->SetValue(nw4f_p_lock_tolerance_tex_scale, 0, m_Lock_tolerance_tex_scale);
    pblock->SetValue(nw4f_p_lock_tolerance_tex_rotate, 0, m_Lock_tolerance_tex_rotate);
    pblock->SetValue(nw4f_p_lock_tolerance_tex_translate, 0, m_Lock_tolerance_tex_translate);
    pblock->SetValue(nw4f_p_lock_quantize_tolerance_scale, 0, m_Lock_quantize_tolerance_scale);
    pblock->SetValue(nw4f_p_lock_quantize_tolerance_rotate, 0, m_Lock_quantize_tolerance_rotate);
    pblock->SetValue(nw4f_p_lock_quantize_tolerance_translate, 0, m_Lock_quantize_tolerance_translate);
    pblock->SetValue(nw4f_p_lock_quantize_tolerance_tex_scale, 0, m_Lock_quantize_tolerance_tex_scale);
    pblock->SetValue(nw4f_p_lock_quantize_tolerance_tex_rotate, 0, m_Lock_quantize_tolerance_tex_rotate);
    pblock->SetValue(nw4f_p_lock_quantize_tolerance_tex_translate, 0, m_Lock_quantize_tolerance_tex_translate);
    pblock->SetValue(nw4f_p_lock_pre_export_script, 0, m_Lock_pre_export_script);
    pblock->SetValue(nw4f_p_lock_post_export_script, 0, m_Lock_post_export_script);

    //internal

    m_Opt.m_TexFolderPath = m_Opt.m_OutFolderPath + Dcc::RExpOpt::TexFolderName + "/";
    m_Opt.m_G3dToolPath      = Get3dCommandLineToolsPath();

}

#if (MAX_VERSION_MAJOR >= 15) // max2013
#define PARAM_END p_end
#else
#define PARAM_END end
#endif



///////////////////////////////////////////////////////////////
// 設定のカスタムアトリビュートのパラメータブロックの定義
ParamBlockDesc2 nw4fSetting( nw4f_params, _T("Nw4f Parameters"),  0, GetNintendoAttribDesc(),
    P_AUTO_CONSTRUCT + P_VERSION, 6, 0,

    nw4f_p_optionVersion, _T("SavedVersion"), TYPE_INT, 0, 0,
        p_default,	0, 	PARAM_END,

    nw4f_p_exportAllNode,	_T("ExportAllNode"), TYPE_BOOL, 0, 0,
        p_default,	TRUE, 	PARAM_END,
    nw4f_p_outFolder,	_T("OutFolderPath"), TYPE_STRING, 0, 0, PARAM_END,
    nw4f_p_outName,	_T("OutFileName"), TYPE_STRING, 0, 0, PARAM_END,

    nw4f_p_obsolete_use3DEditor, _T("Use3DEditor"), TYPE_BOOL, 0, 0, //パラメータブロックの互換性のため、削除しない
        p_default,	FALSE, 	PARAM_END,

    nw4f_p_mergeFmdFlag,	_T("MergeFmd"), TYPE_BOOL, 0, 0, PARAM_END,
    nw4f_p_mergeFmdPath,	_T("MergeFilename"), TYPE_STRING, 0, 0, PARAM_END,
    nw4f_p_mergeFmdAuto,	_T("MergeFmdAuto"), TYPE_BOOL, 0, 0, PARAM_END,

    nw4f_p_magnify,	_T("Magnify"), TYPE_FLOAT, 0, 0,
        p_default,	1.0f, 	PARAM_END,
    nw4f_p_exportAllFrames,	_T("ExportAllFrames"), TYPE_BOOL, 0, 0,
        p_default,	TRUE, 	PARAM_END,
    nw4f_p_startFrame,	_T("StartFrame"), TYPE_INT, 0, 0,
        p_default,	0, 	PARAM_END,
    nw4f_p_endFrame,	_T("EndFrame"), TYPE_INT, 0, 0,
        p_default,	100, 	PARAM_END,

    nw4f_p_useFigureMode,	_T("UseFigureMode"), TYPE_BOOL, 0, 0,
        p_default,	FALSE, 	PARAM_END,

    nw4f_p_binaryFormat,	_T("IsBinaryFormat"), TYPE_BOOL, 0, 0,
        p_default,	TRUE, 	PARAM_END,

    nw4f_p_exportModel,			_T("ExportModel"), TYPE_BOOL, 0, 0, PARAM_END,
    nw4f_p_exportSkeletalAnim,	_T("ExportSkeletalAnim"), TYPE_BOOL, 0, 0, PARAM_END,
    nw4f_p_exportBoneVisAnim,	_T("ExportBoneVisAnim"), TYPE_BOOL, 0, 0,  PARAM_END,
    nw4f_p_exportMtlColAnim,	_T("ExportMtlColorAnim"), TYPE_BOOL, 0, 0,  PARAM_END,
    nw4f_p_exportMtlTexSRTAnim,	_T("ExportMtlTexSRTAnim"), TYPE_BOOL, 0, 0,  PARAM_END,
    nw4f_p_exportMtlTexPatAnim,	_T("ExportMtlTexPatternAnim"), TYPE_BOOL, 0, 0, PARAM_END,
    nw4f_p_exportShapeAnim,		_T("ExportShapeAnim"), TYPE_BOOL, 0, 0, PARAM_END,

    nw4f_p_exportCam,			_T("ExportCamera"), TYPE_BOOL, 0, 0, PARAM_END,
    nw4f_p_exportLight,			_T("ExportLight"), TYPE_BOOL, 0, 0, PARAM_END,
    nw4f_p_exportSceneAnim,		_T("ExportSceneAnim"), TYPE_BOOL, 0, 0, PARAM_END,
    nw4f_p_exportEnv,			_T("ExportEnv"), TYPE_BOOL, 0, 0, PARAM_END,

    nw4f_p_exportTex,			_T("ExportTexture"), TYPE_BOOL, 0, 0, PARAM_END,

    nw4f_p_compressBoneMode,	_T("CompressBoneMode"), TYPE_INT, 0, 0, PARAM_END,

    nw4f_p_uniteChild,			_T("UniteChild"), TYPE_BOOL, 0, 0, PARAM_END,
    nw4f_p_compressMtl,			_T("CompressMaterial"), TYPE_BOOL, 0, 0, PARAM_END,
    nw4f_p_compressShape,		_T("CompressShape"), TYPE_BOOL, 0, 0, PARAM_END,
    nw4f_p_optimizePrim,		_T("OptimizePrimitive"), TYPE_BOOL, 0, 0, PARAM_END,
    nw4f_p_quantizationAnalysis, _T("QuantizationAnalysis"), TYPE_BOOL, 0, 0, PARAM_END,

    nw4f_p_quantPos,	_T("QuantPos"), TYPE_FLOAT, 0, 0, PARAM_END,
    nw4f_p_quantNormal,	_T("QuantNrm"), TYPE_FLOAT, 0, 0, PARAM_END,
    nw4f_p_quantTex,	_T("QuantTex"), TYPE_FLOAT, 0, 0, PARAM_END,

    nw4f_p_framePrecision,	_T("FramePrecision"), TYPE_INT, 0, 0, PARAM_END,
    nw4f_p_isLoop,			_T("LoopAnim"), TYPE_BOOL, 0, 0, PARAM_END,

    nw4f_p_toleranceTrans,	_T("TolT"), TYPE_FLOAT, 0, 0, PARAM_END,
    nw4f_p_toleranceRotate,	_T("TolR"), TYPE_FLOAT, 0, 0, PARAM_END,
    nw4f_p_toleranceScale,	_T("TolS"), TYPE_FLOAT, 0, 0, PARAM_END,

    nw4f_p_toleranceUVTrans,	_T("TolTexT"), TYPE_FLOAT, 0, 0, PARAM_END,
    nw4f_p_toleranceUVRotate,	_T("TolTexR"), TYPE_FLOAT, 0, 0, PARAM_END,
    nw4f_p_toleranceUVScale,	_T("TolTexS"), TYPE_FLOAT, 0, 0, PARAM_END,
    nw4f_p_toleranceColor,		_T("TolC"), TYPE_FLOAT, 0, 0, PARAM_END,

    nw4f_p_quantToleranceTrans,	_T("QuantTolT"), TYPE_FLOAT, 0, 0, PARAM_END,
    nw4f_p_quantToleranceRotate,	_T("QuantTolR"), TYPE_FLOAT, 0, 0, PARAM_END,
    nw4f_p_quantToleranceScale,	_T("QuantTolS"), TYPE_FLOAT, 0, 0, PARAM_END,

    nw4f_p_quantToleranceUVTrans,	_T("QuantTolTexT"), TYPE_FLOAT, 0, 0, PARAM_END,
    nw4f_p_quantToleranceUVRotate,	_T("QuantTolTexR"), TYPE_FLOAT, 0, 0, PARAM_END,
    nw4f_p_quantToleranceUVScale,	_T("QuantTolTexS"), TYPE_FLOAT, 0, 0, PARAM_END,
    nw4f_p_quantToleranceFrame,		_T("QuantTolFrame"), TYPE_FLOAT, 0, 0, PARAM_END,

    // Ver 2
    nw4f_p_mergeFtxFlag,	_T("MergeFtx"), TYPE_BOOL, 0, 0, PARAM_END,
    nw4f_p_mergeAnimFlag,	_T("MergeAnim"), TYPE_BOOL, 0, 0, PARAM_END,
    nw4f_p_mergeAnimFolder,	_T("MergeAnimFolder"), TYPE_STRING, 0, 0, PARAM_END,
    nw4f_p_mergeAnimName,	_T("MergeAnimName"), TYPE_STRING, 0, 0, PARAM_END,

    // Ver 3
    nw4f_p_disableZYAxisConversion,	_T("DisableZYAxisConversion"), TYPE_BOOL, 0, 0,
        p_default,	FALSE, 	PARAM_END,

    // Ver 4
    nw4f_p_commnetText,	_T("CommentText"), TYPE_STRING, 0, 0,
        p_default,	"",		PARAM_END,

    // Ver 5
    nw4f_p_presetName,	_T("PresetName"), TYPE_STRING, 0, 0, p_default,	"",	PARAM_END,
    nw4f_p_presetFile,	_T("PresetFile"), TYPE_STRING, 0, 0, p_default,	"",	PARAM_END,
    nw4f_p_showPresetUI, _T("ShowPresetUI"), TYPE_BOOL, 0, 0, p_default, TRUE, PARAM_END,

    nw4f_p_lock_export_target, _T("lock_export_target"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_output_file_name, _T("lock_output_file_name"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_output_folder, _T("lock_output_folder"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_obsolete_lock_use_3deditor, _T("lock_use_3deditor"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_use_figure_mode, _T("lock_use_figure_mode"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_merge_fmd, _T("lock_merge_fmd"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_merge_ftx, _T("lock_merge_ftx"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_merge_anim, _T("lock_merge_anim"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_merge_anim_name, _T("lock_merge_anim_name"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_magnify, _T("lock_magnify"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_comment, _T("lock_comment"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_frame_range, _T("lock_frame_range"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_loop_anim, _T("lock_loop_anim"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_bake_all_anim, _T("lock_bake_all_anim"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_frame_precision, _T("lock_frame_precision"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_output_fmd, _T("lock_output_fmd"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_output_ftx, _T("lock_output_ftx"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_output_fsk, _T("lock_output_fsk"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_output_fvb, _T("lock_output_fvb"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_output_fcl, _T("lock_output_fcl"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_output_fts, _T("lock_output_fts"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_output_ftp, _T("lock_output_ftp"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_output_fsh, _T("lock_output_fsh"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_output_fsn, _T("lock_output_fsn"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_compress_bone, _T("lock_compress_bone"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_unite_child, _T("lock_unite_child"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_compress_material, _T("lock_compress_material"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_compress_shape, _T("lock_compress_shape"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_tolerance_scale, _T("lock_tolerance_scale"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_tolerance_rotate, _T("lock_tolerance_rotate"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_tolerance_translate, _T("lock_tolerance_translate"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_tolerance_color, _T("lock_tolerance_color"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_tolerance_tex_scale, _T("lock_tolerance_tex_scale"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_tolerance_tex_rotate, _T("lock_tolerance_tex_rotate"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_tolerance_tex_translate, _T("lock_tolerance_tex_translate"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_quantize_tolerance_scale, _T("lock_quantize_tolerance_scale"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_quantize_tolerance_rotate, _T("lock_quantize_tolerance_rotate"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_quantize_tolerance_translate, _T("lock_quantize_tolerance_translate"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_quantize_tolerance_tex_scale, _T("lock_quantize_tolerance_tex_scale"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_quantize_tolerance_tex_rotate, _T("lock_quantize_tolerance_tex_rotate"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_quantize_tolerance_tex_translate, _T("lock_quantize_tolerance_tex_translate"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_pre_export_script, _T("lock_pre_export_script"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_p_lock_post_export_script, _T("lock_post_export_script"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,

    // ver 6
    nw4f_p_preExportScript,	_T("PreExportScript"), TYPE_STRING, 0, 0,
        p_default,	"",		PARAM_END,
    nw4f_p_postExportScript,_T("PostExportScript"), TYPE_STRING, 0, 0,
        p_default,	"",		PARAM_END,

    PARAM_END
);

NintendoCustAttrib::NintendoCustAttrib()
{
    pblock = NULL;
    GetNintendoAttribDesc()->MakeAutoParamBlocks(this);
}


ReferenceTarget* NintendoCustAttrib::Clone(RemapDir &remap)
{
    NintendoCustAttrib* pnew = new NintendoCustAttrib;
    pnew->ReplaceReference(0,remap.CloneRef(pblock));
    BaseClone(this, pnew, remap);
    return pnew;
}


///////////////////////////////////////////////////////////////
// ノードのカスタムアトリビュートのパラメータブロックの定義
ParamBlockDesc2 nw4fNodeSetting( 0, _T("Nw4f Node Parameters"),  0, GetNintendoNodeAttribDesc(),
    P_AUTO_CONSTRUCT + P_VERSION, 2, 0,

    nw4f_node_noCompress,	_T("noCompress"), TYPE_BOOL, 0, 0,  PARAM_END,

    nw4f_node_shapeExportPosition,	_T("exportShapePosition"), TYPE_BOOL, 0, 0, p_default, TRUE, PARAM_END,
    nw4f_node_shapeExportNormal,	_T("exportShapeNormal"), TYPE_BOOL, 0, 0, p_default, TRUE, PARAM_END,
    nw4f_node_shapeExportColor,		_T("exportShapeColor"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,

    nw4f_node_userSettingString,	_T("userSettings"), TYPE_STRING, 0, 0,
        p_default,	"",
        PARAM_END,

    PARAM_END
);

NintendoNodeCustAttrib::NintendoNodeCustAttrib()
{
    pblock = NULL;
    GetNintendoNodeAttribDesc()->MakeAutoParamBlocks(this);
}

ReferenceTarget* NintendoNodeCustAttrib::Clone(RemapDir &remap)
{
    NintendoNodeCustAttrib* pnew = new NintendoNodeCustAttrib;
    pnew->ReplaceReference(0,remap.CloneRef(pblock));
    BaseClone(this, pnew, remap);
    return pnew;
}

///////////////////////////////////////////////////////////////
// materialのカスタムアトリビュートのパラメータブロックの定義
static void initMtlPriorityDlg(HWND hWnd, BOOL flag)
{
    if(!hWnd) return;

    ISpinnerControl* spin = GetISpinner(GetDlgItem(hWnd, IDC_PRIORITY_SPINNER));
    ICustEdit* edit = GetICustEdit(GetDlgItem(hWnd, IDC_PRIORITY_EDIT));
    if(spin && edit)
    {
        if (flag)
        {
            spin->Enable();
            edit->Enable();
        }
        else
        {
            spin->Disable();
            edit->Disable();
        }
    }
    ReleaseISpinner(spin);
    ReleaseICustEdit(edit);
}

class MtlDlgProc : public ParamMap2UserDlgProc
{
public:
    INT_PTR DlgProc(TimeValue t, IParamMap2* map, HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
    {
        char* n_facecull[4] = {"Back Face", "Front Face", "Always", "Never"};
        char* n_compress[2] = {"Compress if possible", "Don't compress"};
        char* n_blendmode[7] = {"Auto", "Opaque", "Alpha Test", "Translucent", "Add", "Sub", "Multiply"};

        NintendoMtlCustAttrib* p = (NintendoMtlCustAttrib*)map->GetParamBlock()->GetOwner();
        p->m_hPanel = hWnd;

        switch (msg)
        {
            case WM_INITDIALOG:
            {
                HWND hwndCB;
                hwndCB = GetDlgItem(hWnd, IDC_COMPRESS);
                SendMessage(hwndCB, CB_RESETCONTENT, 0L, 0L);
                for(int i = 0; i < 2; i++)
                {
                    SendMessage(hwndCB, CB_ADDSTRING, 0L, (LPARAM)A_2_M(n_compress[i]) );
                }
                /*
                hwndCB = GetDlgItem(hWnd, IDC_FACECULL);
                SendMessage(hwndCB, CB_RESETCONTENT, 0L, 0L);
                for(int i = 0; i < 4; i++)
                {
                    SendMessage(hwndCB, CB_ADDSTRING, 0L, (LPARAM)A_2_M(n_facecull[i]) );
                }
                hwndCB = GetDlgItem(hWnd, IDC_BLENDMODE);
                SendMessage(hwndCB, CB_RESETCONTENT, 0L, 0L);
                for(int i = 0; i < 7; i++)
                {
                    SendMessage(hwndCB, CB_ADDSTRING, 0L, (LPARAM)A_2_M(n_blendmode[i]) );
                }
                if(p->pblock)
                {
                    BOOL flag = (1 == p->pblock->GetInt(nw4f_mtl_renderPriorityType));
                    initMtlPriorityDlg(hWnd, flag);
                }
                */

                break;
            }
        }
        return FALSE;
    }

    void DeleteThis() { }
};
class MtlPBAccessor : public PBAccessor
{
public:
    virtual void Set(PB2Value& v, ReferenceMaker* owner, ParamID id, int tabIndex, TimeValue t) override
    {
        assert(owner->ClassID() == NINTENDOEXPORT_MTL_ATTRIB_CLASS_ID);
        NintendoMtlCustAttrib* p = static_cast<NintendoMtlCustAttrib*>(owner);
        if(p->m_hPanel && p->pblock != NULL)
        {
            /*
            switch(id)
            {
                case nw4f_mtl_renderPriorityType:
                {
                    BOOL flag = (v.i == 1);
                    initMtlPriorityDlg(p->m_hPanel, flag);
                    int val = p->pblock->GetInt(nw4f_mtl_renderPriority);
                    if(val < 1)
                    {
                        p->pblock->SetValue(nw4f_mtl_renderPriority, 0, 1);
                    }
                    else if(val > 255)
                    {
                        p->pblock->SetValue(nw4f_mtl_renderPriority, 0, 255);
                    }
                    break;
                }
                case nw4f_mtl_renderPriority:
                {
                    if(v.i < 1)
                    {
                        v.i = 1;
                    }
                    else if(v.i > 255)
                    {
                        v.i = 255;
                    }
                    break;
                }
            }
            */
        }
    }
};

static MtlDlgProc mtlDlgProc;
static MtlPBAccessor mtlPBAccessor;

ParamBlockDesc2 nw4fMtlSetting( 0, _T("Nw4f Material Parameters"),  0, GetNintendoMtlAttribDesc(),
    P_AUTO_CONSTRUCT + P_AUTO_UI+ P_VERSION, 1, 0,
    //rollout
    IDD_MTL_CA_PANEL, IDS_NW4F_MTL_CA, 0, 0, &mtlDlgProc,
    // parameters
    nw4f_mtl_compress,			_T("compress"), TYPE_INT, 0, 0,
        p_default,	0,
        p_ui, 		TYPE_INTLISTBOX, IDC_COMPRESS, 0,
        PARAM_END,
    nw4f_mtl_userSettingString,	_T("userSettings"), TYPE_STRING, 0, 0,
        p_default,	"",
        PARAM_END,
/*
    nw4f_mtl_faceCulling,		_T("faceCulling"), TYPE_INT, 0, 0,
        p_default,	0,
        p_ui, 		TYPE_INTLISTBOX, IDC_FACECULL, 0,
        PARAM_END,
    nw4f_mtl_fragmentLighting,	_T("fragmentLighting"), TYPE_BOOL, 0, 0,
        p_default,	TRUE,
        p_ui, 		TYPE_SINGLECHEKBOX, IDC_FRAGLIGHT,
        PARAM_END,
    nw4f_mtl_vertexLighting,	_T("vertexLighting"), TYPE_BOOL, 0, 0,
        p_default,	FALSE,
        p_ui, 		TYPE_SINGLECHEKBOX, IDC_VTXLIGHT,
        PARAM_END,
    nw4f_mtl_renderPriorityType,_T("renderPriorityType"), TYPE_INT, 0, 0,
        p_default,	0,
        p_range,	0, 1,
        p_ui, 		TYPE_RADIO, 2, IDC_PRIORITY_RADIO1, IDC_PRIORITY_RADIO2,
        p_accessor,	&mtlPBAccessor,
        PARAM_END,
    nw4f_mtl_renderPriority,	_T("renderPriority"), TYPE_INT, 0, 0,
        p_default,	0,
        p_range,	1, 255,
        p_ui, 		TYPE_SPINNER, EDITTYPE_POS_INT, IDC_PRIORITY_EDIT, IDC_PRIORITY_SPINNER, SPIN_AUTOSCALE,
        PARAM_END,
    nw4f_mtl_blendMode,			_T("blendMode"), TYPE_INT, 0, 0,
        p_default,	0,
        p_ui, 		TYPE_INTLISTBOX, IDC_BLENDMODE, 0,
        PARAM_END,
*/
    PARAM_END
);

NintendoMtlCustAttrib::NintendoMtlCustAttrib()
{
    pblock = NULL;
    m_hPanel = NULL;
    GetNintendoMtlAttribDesc()->MakeAutoParamBlocks(this);
}

ReferenceTarget* NintendoMtlCustAttrib::Clone(RemapDir &remap)
{
    NintendoMtlCustAttrib* pnew = new NintendoMtlCustAttrib;
    pnew->ReplaceReference(0,remap.CloneRef(pblock));
    BaseClone(this, pnew, remap);
    return pnew;
}

ParamDlg* NintendoMtlCustAttrib::CreateParamDlg(HWND hwMtlEdit, IMtlParams* imp)
{
    return GetNintendoMtlAttribDesc()->CreateParamDlgs(hwMtlEdit, imp, this);
}

///////////////////////////////////////////////////////////////
// サンプラーのカスタムアトリビュートのパラメータブロックの定義
ParamBlockDesc2 nw4fSamplerSetting( 0, _T("Nw4f Sampler Parameters"),  0, GetNintendoSamplerAttribDesc(),
    P_AUTO_CONSTRUCT + P_VERSION, 0, 0,

    nw4f_sampler_name,	_T("samplerName"), TYPE_STRING, 0, 0,
        p_default,	"",
        PARAM_END,
    nw4f_sampler_hint,	_T("samplerHint"), TYPE_STRING, 0, 0,
        p_default,	"",
        PARAM_END,
    PARAM_END
);

///////////////////////////////////////////////////////////////
// マルチエキスポートのカスタムアトリビュートのパラメータブロックの定義
ParamBlockDesc2 nw4fMultiExportSetting( 0, _T("Nw4f MultiExport Parameters"),  0, GetNintendoMultiExportAttribDesc(),
    P_AUTO_CONSTRUCT + P_VERSION, 0, 0,

    nw4f_mrender_filename,				_T("Filename"),		TYPE_STRING, 0, 0, p_default,	"", PARAM_END,
    nw4f_mrender_folder,				_T("Folder"),		TYPE_STRING, 0, 0, p_default,	"", PARAM_END,
    nw4f_mrender_doesMergeFmd,			_T("MergeFmd"),		TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_mrender_mergeFmdFile,			_T("MergeFmdFile"), TYPE_STRING, 0, 0, p_default,	"", PARAM_END,
    nw4f_mrender_fdesFile,				_T("FdesFile"),		TYPE_STRING, 0, 0, p_default,	"", PARAM_END,
    nw4f_mrender_nodes,					_T("Nodes"),		TYPE_STRING, 0, 0, p_default,	"", PARAM_END,
    nw4f_mrender_dispLayers,			_T("DispLayers"),	TYPE_STRING, 0, 0, p_default,	"", PARAM_END,
    nw4f_mrender_animLayers,			_T("AnimLayers"),	TYPE_STRING, 0, 0, p_default,	"", PARAM_END,
    nw4f_mrender_comment,				_T("Comment"),		TYPE_STRING, 0, 0, p_default,	"", PARAM_END,
    nw4f_mrender_doesExportAllFrames,	_T("ExportAllFrames"), TYPE_BOOL, 0, 0, p_default, TRUE, PARAM_END,
    nw4f_mrender_startFrame,			_T("StartFrame"),	TYPE_INT, 0, 0, p_default,	0, 	PARAM_END,
    nw4f_mrender_endFrame,				_T("EndFrame"),		TYPE_INT, 0, 0, p_default,	100, 	PARAM_END,
    nw4f_mrender_isLoop,				_T("LoopAnim"),		TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,

    nw4f_mrender_exportModel,			_T("ExportModel"), TYPE_BOOL, 0, 0, p_default, TRUE, PARAM_END,
    nw4f_mrender_exportTex,				_T("ExportTexture"), TYPE_BOOL, 0, 0, p_default, TRUE, PARAM_END,
    nw4f_mrender_exportSkeletalAnim,	_T("ExportSkeletalAnim"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_mrender_exportBoneVisAnim,		_T("ExportBoneVisAnim"), TYPE_BOOL, 0, 0,  p_default, FALSE, PARAM_END,
    nw4f_mrender_exportMtlColAnim,		_T("ExportMtlColorAnim"), TYPE_BOOL, 0, 0,  p_default, FALSE, PARAM_END,
    nw4f_mrender_exportMtlTexSRTAnim,	_T("ExportMtlTexSRTAnim"), TYPE_BOOL, 0, 0,  p_default, FALSE, PARAM_END,
    nw4f_mrender_exportMtlTexPatAnim,	_T("ExportMtlTexPatternAnim"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_mrender_exportShapeAnim,		_T("ExportShapeAnim"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,
    nw4f_mrender_exportSceneAnim,		_T("ExportSceneAnim"), TYPE_BOOL, 0, 0, p_default, FALSE, PARAM_END,

    nw4f_mrender_options,				_T("Options"),		TYPE_STRING, 0, 0, p_default,	"", PARAM_END,

    PARAM_END
);
