﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <util/UtilPrint.h>

namespace nw { namespace g3d { namespace tool {
namespace util {

void VPrintImpl(FILE* stream, const wchar_t* format, va_list arglist)
{
    int length = vfwprintf_s(stream, format, arglist); // 標準(エラー)出力に出力
    // エラーチェック
    if (length < 0)
    {
        fprintf(stream, "VPrintImpl");
    }
    else
    {
        if (IsDebuggerPresent())
        {
            wchar_t* str = static_cast<wchar_t*>(_malloca(sizeof(wchar_t) * (length + 1)));
            vswprintf_s(str, length + 1, format, arglist);
            OutputDebugStringW(str); // デバッガに出力
            _freea(str);
        }
    }
}

void PrintImpl(FILE* stream, const wchar_t* format, ...)
{
    va_list arglist;
    va_start(arglist, format);
    VPrintImpl(stream, format, arglist);
    va_end(arglist);
}

void PrintLnImpl(FILE* stream, const wchar_t* format, ...)
{
    va_list arglist;
    va_start(arglist, format);
    VPrintImpl(stream, format, arglist);
    va_end(arglist);
    PrintImpl(stream, L"\n");
}

} // namespace util

} // namespace tool
} // namespace g3d
} // namespace nw
