﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <util/UtilFile.h>
#include <shlwapi.h>

namespace nw { namespace g3d { namespace tool {
namespace util {


void DeleteDirectory(LPCTSTR lpPathName)
{
    WIN32_FIND_DATA file;
    std::vector<std::wstring> fileList;

    std::wstringstream wss;
    wss << lpPathName << L"?*";

    HANDLE handle = FindFirstFile(wss.str().c_str(), &file);

    if (handle != INVALID_HANDLE_VALUE)
    {
        fileList.push_back(file.cFileName);

        for( ; ; )
        {
            if( !FindNextFile( handle, &file ) )
            {
                break;
            }

            fileList.push_back(file.cFileName);
        }
    }

    if (handle != NULL)
    {
        FindClose(handle);
    }

    for (auto fileName = fileList.cbegin(); fileName != fileList.cend(); ++fileName)
    {
        std::wstringstream wStringStream;
        wStringStream << lpPathName << *fileName;
        if (DeleteFile(wStringStream.str().c_str()) == FALSE)
        {
            //printf("false: %d\n", GetLastError());
        }
    }

    RemoveDirectory(lpPathName);
}

BOOL CreateDirectory(LPCTSTR lpPathName, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
    if (::CreateDirectory(lpPathName, lpSecurityAttributes))
    {
        return TRUE;
    }

    std::wstring pathDir = lpPathName;
    std::vector<std::wstring> hierarchyDir;
    for( ; ; )
    {
        auto pos = pathDir.find_last_of(L"/");
        if (pos == std::string::npos)
        {
            break;
        }

        std::wstring subdir = pathDir.substr(0, pos + 1);
        if (PathIsDirectory(subdir.c_str()))
        {
            break;
        }
        else
        {
            hierarchyDir.push_back(subdir);
        }
        pathDir = pathDir.substr(0, pos);
    }

    for (auto dir = hierarchyDir.crbegin(); dir != hierarchyDir.crend(); ++dir)
    {
        if (!::CreateDirectory(dir->c_str(), lpSecurityAttributes))
        {
            return FALSE;
        }
    }


    return PathIsDirectory(lpPathName);
}

} // namespace util

} // namespace tool
} // namespace g3d
} // namespace nw
