﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <util/UtilError.h>
#include <util/UtilString.h>

namespace nw { namespace g3d { namespace tool {

LogConfig::Level LogConfig::s_Level = LogConfig::Verbose;

FILE* LogConfig::s_Out = stdout;
FILE* LogConfig::s_Warning = stdout;
FILE* LogConfig::s_Err = stderr;
bool LogConfig::s_InternalTrace = true;
bool LogConfig::s_Trace = false;
HINSTANCE LogConfig::s_StringResourceDll;

bool LogConfig::InitializeStringResource(const char* stringResourcePath)
{
#if defined(_M_IX86)
    s_StringResourceDll = LoadLibrary(L"x86\\StringResourceUtil.dll");
#else
    s_StringResourceDll = LoadLibrary(L"StringResourceUtil.dll");
#endif
    if (s_StringResourceDll == nullptr)
    {
        PRINT_SYSTEM_LOG("Faild to load StringResourceUtil.dll");
        return false;
    }

    PROC_STRING_RESOURCE_ADDRESS(s_StringResourceDll, InitializeStringResource, bool(*)());
    PROC_STRING_RESOURCE_ADDRESS(s_StringResourceDll, RegisterCsvFile, bool(*)(const char*));

    InitializeStringResource();
    if (!RegisterCsvFile(stringResourcePath))
    {
        PRINT_SYSTEM_LOG("Faild to setup %hs", stringResourcePath);
        return false;
    }

    // 現在エラー出力しか行わないので、日本語の場合はエラー出力設定を UTF8 にしておく
    if (GetUserDefaultLCID() == 1041)
    {
        _setmode(_fileno(nw::g3d::tool::LogConfig::s_Err), _O_U8TEXT);
    }
    return true;
}

namespace {

int PrintErrorSource(const char* source, int line)
{
    std::vector<std::string> lines;
    std::string str = util::ToLocale(source);
    util::Split(lines, str, util::LF, false);
    for (int i = 0; i < static_cast<int>(lines.size()); ++i)
    {
        PRINT_ERROR_LOG("%4d | %hs", line++, lines[i].c_str());
    }
    PRINT_ERROR_LOG("%4d | ", line++);
    return line;
}

}

void PrintErrorSource(const char* source)
{
    PrintErrorSource(source, 1);
}

void PrintErrorSource(const std::vector<const char*>* sources)
{
    int line = 1;
    for (auto source : *sources)
    {
        line = PrintErrorSource(source, line);
    }
}

} // namespace tool
} // namespace g3d
} // namespace nw
