﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <util/types.h>

namespace nw { namespace g3d { namespace tool {
namespace util {

template<typename T>
inline T Round(float src)
{
    if (src > 0.0f)
    {
        return static_cast<T>(std::floor(src + 0.5f));
    }
    else
    {
        return static_cast<T>(std::ceil(src - 0.5f));
    }
}

inline static float Pi() { return 3.141592653589793f; } // 円周率

inline float RadToDeg(float rad)
{
    return rad * (180.0f / Pi());
}

inline float DegToRad(float deg)
{
    return deg * (Pi() / 180.0f);
}

inline float Select(float cond, float pos, float neg)
{
    return cond >=0 ? pos : neg;
}

inline float Min(float x, float y)
{
    return Select(x - y, y, x);
}

inline float Max(float x, float y)
{
    return Select(x - y, x, y);
}

inline float Clamp(float x, float minVal, float maxVal)
{
    return Max(minVal, Min(maxVal, x));
}

} // namespace util
} // namespace tool
} // namespace g3d
} // namespace nw
