﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <g3dif/Serialization.h>
#include <g3dif/UserData.h>
#include <g3dif/Stream.h>
#include <g3dif/UserData.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

//--------------------------------------------------------------------------------------------------

class elem_texture_info
{
public:
    G3DIF_DEFINE_ENUM(dimension,
        dim_1d,
        dim_2d,
        dim_3d,
        dim_cube,
        dim_1d_array,
        dim_2d_array,
        dim_cube_array
        );

    G3DIF_DEFINE_ENUM(quantize_type,
        type_8_unorm,
        type_8_uint,
        type_8_snorm,
        type_8_sint,
        type_4_4_unorm,
        type_16_unorm,
        type_16_uint,
        type_16_snorm,
        type_16_sint,
        type_16_float,
        type_8_8_unorm,
        type_8_8_uint,
        type_8_8_snorm,
        type_8_8_sint,
        type_5_6_5_unorm,
        type_5_5_5_1_unorm,
        type_4_4_4_4_unorm,
        type_1_5_5_5_unorm,
        type_32_uint,
        type_32_sint,
        type_32_float,
        type_16_16_unorm,
        type_16_16_uint,
        type_16_16_snorm,
        type_16_16_sint,
        type_16_16_float,
        type_11_11_10_float,
        type_10_10_10_2_unorm,
        type_10_10_10_2_uint,
        type_8_8_8_8_unorm,
        type_8_8_8_8_uint,
        type_8_8_8_8_snorm,
        type_8_8_8_8_sint,
        type_8_8_8_8_srgb,
        type_2_10_10_10_unorm,
        type_2_10_10_10_uint,
        type_32_32_uint,
        type_32_32_sint,
        type_32_32_float,
        type_16_16_16_16_unorm,
        type_16_16_16_16_uint,
        type_16_16_16_16_snorm,
        type_16_16_16_16_sint,
        type_16_16_16_16_float,
        type_32_32_32_32_uint,
        type_32_32_32_32_sint,
        type_32_32_32_32_float,
        type_bc1_unorm,
        type_bc1_srgb,
        type_bc2_unorm,
        type_bc2_srgb,
        type_bc3_unorm,
        type_bc3_srgb,
        type_bc4_unorm,
        type_bc4_snorm,
        type_bc5_unorm,
        type_bc5_snorm
        );

    G3DIF_DEFINE_ENUM(tile_mode,
        mode_linear,
        mode_linear_aligned,
        mode_1d_tiled_thin1,
        mode_1d_tiled_thick,
        mode_2d_tiled_thin1,
        mode_2d_tiled_thin2,
        mode_2d_tiled_thin4,
        mode_2d_tiled_thick,
        mode_2b_tiled_thin1,
        mode_2b_tiled_thin2,
        mode_2b_tiled_thin4,
        mode_2b_tiled_thick,
        mode_3d_tiled_thin1,
        mode_3d_tiled_thick,
        mode_3b_tiled_thin1,
        mode_3b_tiled_thick
        );

    G3DIF_DEFINE_ENUM(comp_sel,
        comp_sel_r,
        comp_sel_g,
        comp_sel_b,
        comp_sel_a,
        comp_sel_0,
        comp_sel_1
        );

    elem_texture_info()
        : linear()
        , dimension(dim_2d)
        , quantize_type(type_8_8_8_8_unorm)
        , width(0)
        , height(0)
        , depth(0)
        , mip_level(1)
        , size(0)
        , comp_sel("r g b a")
        , tile_mode(mode_2d_tiled_thin1)
        , swizzle(0)
        , alignment(0)
        , pitch(0)
        , stream_index(-1)
    {
    }

    G3DIF_DEFINE_ELEM(texture_info);

    G3DIF_DEFINE_ATTRIB(std::string, linear);
    G3DIF_DEFINE_ATTRIB(enum_dimension, dimension);
    G3DIF_DEFINE_ATTRIB(enum_quantize_type, quantize_type);
    G3DIF_DEFINE_ATTRIB(int, width);
    G3DIF_DEFINE_ATTRIB(int, height);
    G3DIF_DEFINE_ATTRIB(int, depth);
    G3DIF_DEFINE_ATTRIB(int, mip_level);
    G3DIF_DEFINE_ATTRIB(int, size);
    G3DIF_DEFINE_ATTRIB(std::string, comp_sel);
    G3DIF_DEFINE_ATTRIB(enum_tile_mode, tile_mode);
    G3DIF_DEFINE_ATTRIB(int, swizzle);
    G3DIF_DEFINE_ATTRIB(int, alignment);
    G3DIF_DEFINE_ATTRIB(int, pitch);
    G3DIF_DEFINE_ATTRIB(UIntStream, mip_offset);
    G3DIF_DEFINE_ATTRIB(int, stream_index);

    bool linear_flag[4];
    enum_comp_sel component_selector[4];
};

//--------------------------------------------------------------------------------------------------
class elem_texture
{
public:

    elem_texture()
        : name()
        , path()
        , stream()
        , user_data_array()
        , actualTextureSize( -1 )
    {
    }

    G3DIF_DEFINE_ELEM(texture);

    void SetName(const char* fileName) { this->name.assign(fileName); }
    void SetPath(const char* filePath) { this->path.assign(filePath); }
    void PostProcess();
    void PostBinaryProcess(void* data);

    //! 読み込んだデータの整合性を確認します。
    void CheckData(int flag);

    std::string name;
    std::string path;
    std::vector<elem_stream> stream_array;
    elem_texture_info texture_info;
    std::vector<elem_user_data> user_data_array;

    DataStream stream; // 参照解決後に利用可。
    int actualTextureSize;	// mip1 とそれ以降のミップチェインを分けるイレギュラーな使い方の時に使用する。
};

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
