﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <g3dif/Serialization.h>
#include <g3dif/ShaderConfig.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

class elem_option
{
public:
    elem_option()
        : id()
        , choice()
        , choiceArray()
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(option);

    G3DIF_DEFINE_ATTRIB(std::string, id);
    G3DIF_DEFINE_ATTRIB(std::string, choice);

    std::vector<std::pair<std::string, std::string>> choiceArray;
};

class elem_shader_program
{
public:
    elem_shader_program() {}

    G3DIF_DEFINE_ELEM_ARRAY(shader_program);

    std::vector<elem_option> option_array;
};

class elem_target_shader
{
public:
    elem_target_shader() {}

    G3DIF_DEFINE_ELEM_ARRAY(target_shader);

    G3DIF_DEFINE_ATTRIB(std::string, shading_model_name);

    std::vector<elem_shader_program> shader_program_array;
};

class elem_shader_variation_info
{
public:
    elem_shader_variation_info() {}

    G3DIF_DEFINE_ELEM(shader_variation_info);

    G3DIF_DEFINE_ATTRIB(std::string, shader_archive);
};

//--------------------------------------------------------------------------------------------------

class elem_shader_variation
{
public:
    elem_shader_variation()
        : name()
        , path()
        , shader_variation_info()
        , target_shader_array()
    {
    }

    G3DIF_DEFINE_ELEM(shader_variation);

    G3DIF_DEFINE_ATTRIB(Version, version);

    void PostProcess();
    void SetName(const char* fileName) { this->name.assign(fileName); };
    void SetPath(const char* filePath) { this->path.assign(filePath); }

    //! 読み込んだデータの整合性を確認します。
    void CheckData(int flag);

    std::string name;
    std::string path;

    elem_shader_variation_info shader_variation_info;
    std::vector<elem_target_shader> target_shader_array;
};

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
