﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <util/UtilSerialization.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

enum ShaderStage
{
    ShaderStage_Vertex,
    ShaderStage_Geometry,
    ShaderStage_Fragment,
    ShaderStage_Compute,
    ShaderStage_StageCount
};

//
// xml 要素・属性、内部使用するアノテーション中間ファイルの要素・属性を保持する
// 文字列テーブルのインデックスです。
//
enum Identifier
{
    id_alignment,
    id_alpha_dst_func,
    id_alpha_op,
    id_alpha_src_func,
    id_alpha_test,
    id_alt,
    id_angle_attn_func,
    id_attrib_assign,
    id_attrib_assign_array,
    id_attrib_index,
    id_attrib_name,
    id_attrib_var,
    id_attrib_var_array,
    id_base_name,
    id_base_value,
    id_base_vertex,
    id_bias,
    id_billboard,
    id_binarize,
    id_binarize_scale,
    id_binarize_rotate,
    id_binarize_translate,
    id_binarize_visibility,
    id_binary_offset,
    id_bind_index,
    id_bind_size,
    id_blend_mode,
    id_block_var,
    id_block_var_array,
    id_shader_storage_block_var,
    id_shader_storage_block_var_array,
    id_bone,
    id_bone_anim,
    id_bone_anim_array,
    id_bone_anim_target,
    id_bone_array,
    id_bone_index,
    id_bone_name,
    id_bone_vis_bone_anim,
    id_bone_vis_bone_anim_array,
    id_bone_visibility_anim,
    id_bone_visibility_anim_info,
    id_branch,
    id_camera_anim,
    id_camera_anim_array,
    id_camera_anim_target,
    id_camera_name,
    id_choice,
    id_code_page,
    id_column,
    id_color_blend,
    id_comp_sel,
    id_component_index,
    id_compute_shader,
    id_compute_stage,
    id_compute_symbol,
    id_condition,
    id_config_path,
    id_const_color,
    id_converter,
    id_count,
    id_default,
    id_depend,
    id_depth,
    id_depth_test,
    id_dimension,
    id_display_face,
    id_dist_attn_func,
    id_enable,
    id_env_name,
    id_file,
    id_filter,
    id_force_include,
    id_force_include_array,
    id_force_include_file,
    id_force_include_file_array,
    id_fog_anim,
    id_fog_anim_array,
    id_fog_anim_target,
    id_fog_name,
    id_format,
    id_fragment_shader,
    id_fragment_stage,
    id_fragment_symbol,
    id_frame_count,
    id_frame_type,
    id_func,
    id_geometry_shader,
    id_geometry_stage,
    id_geometry_symbol,
    id_group,
    id_group_array,
    id_group_name,
    id_height,
    id_hermite_curve,
    id_hint,
    id_id,
    id_id_set,
    id_include_path,
    id_include_path_array,
    id_index,
    id_input,
    id_input_array,
    id_interleave,
    id_interleave_array,
    id_inv_model_matrix,
    id_key_shape,
    id_key_shape_array,
    id_key_shape_name,
    id_key_type,
    id_length,
    id_light_anim,
    id_light_anim_array,
    id_light_anim_target,
    id_light_name,
    id_linear,
    id_linear_curve,
    id_lod,
    id_lod_offset,
    id_logical_blend,
    id_loop,
    id_macro,
    id_macro_array,
    id_mag,
    id_mat_name,
    id_mat_vis_mat_anim,
    id_mat_vis_mat_anim_array,
    id_mat_visibility_anim,
    id_mat_visibility_anim_info,
    id_material,
    id_material_array,
    id_material_info,
    id_material_shader,
    id_matrix_index,
    id_max,
    id_max_aniso,
    id_mesh,
    id_mesh_adjacency,
    id_mesh_array,
    id_min,
    id_mip,
    id_mip_level,
    id_mip_offset,
    id_mode,
    id_model,
    id_model_info,
    id_motion_mirroring_enable,
    id_name,
    id_normal_matrix,
    id_nostrip,
    id_nw4f_3dif,
    id_offset,
    id_op,
    id_option,
    id_option_array,
    id_option_var,
    id_option_var_array,
    id_optional,
    id_original_material_anim,
    id_original_material_anim_array,
    id_page,
    id_page_array,
    id_page_name,
    id_path,
    id_param_anim,
    id_param_anim_array,
    id_param_anim_target,
    id_parent_index,
    id_parent_name,
    id_pattern_anim_target,
    id_pattern_index,
    id_pass_name,
    id_pitch,
    id_post_wrap,
    id_pre_wrap,
    id_projection_mode,
    id_quantize_type,
    id_render_info,
    id_render_info_array,
    id_render_info_slot,
    id_render_info_slot_array,
    id_render_state,
    id_revision,
    id_rgb_dst_func,
    id_rgb_op,
    id_rgb_src_func,
    id_rigid_body,
    id_rotate,
    id_rotate_mode,
    id_sampler,
    id_sampler_assign,
    id_sampler_assign_array,
    id_sampler_array,
    id_sampler_index,
    id_sampler_name,
    id_sampler_var,
    id_sampler_var_array,
    id_scale,
    id_scale_compensate,
    id_scale_enable,
    id_scale_mode,
    id_scene_anim,
    id_scene_anim_info,
    id_semantic_index,
    id_semantic_name,
    id_set,
    id_shader,
    id_shader_array,
    id_shader_assign,
    id_shader_archive,
    id_shader_config,
    id_shader_config_info,
    id_shader_definition,
    id_shader_definition_info,
    id_shader_option,
    id_shader_option_array,
    id_shader_param,
    id_shader_param_anim,
    id_shader_param_anim_info,
    id_shader_param_array,
    id_shader_param_mat_anim,
    id_shader_param_mat_anim_array,
    id_shader_path,
    id_shader_program,
    id_shader_program_array,
    id_shader_src,
    id_shader_src_array,
    id_shader_stage,
    id_shader_symbol,
    id_shader_variation,
    id_shader_variation_info,
    id_shading_model,
    id_shading_model_array,
    id_shading_model_name,
    id_shape,
    id_shape_anim,
    id_shape_anim_info,
    id_shape_anim_target,
    id_shape_array,
    id_shape_info,
    id_shape_name,
    id_shape_shader_assign,
    id_side,
    id_size,
    id_skeletal_anim,
    id_skeletal_anim_info,
    id_skeleton,
    id_skeleton_info,
    id_smooth_skinning,
    id_step_curve,
    id_stream,
    id_stream_array,
    id_stream_index,
    id_streamout,
    id_streamout_array,
    id_string,
    id_src_index,
    id_src_type,
    id_submesh,
    id_submesh_array,
    id_submesh_index,
    id_swizzle,
    id_target,
    id_target_attrib,
    id_target_attrib_array,
    id_target_shader,
    id_target_shader_array,
    id_tex_name,
    id_tex_pattern,
    id_tex_pattern_array,
    id_tex_pattern_anim,
    id_tex_pattern_anim_info,
    id_tex_pattern_mat_anim,
    id_tex_pattern_mat_anim_array,
    id_text,
    id_textblock,
    id_textblock_array,
    id_texture,
    id_texture_info,
    id_tile_mode,
    id_tool_data,
    id_translate,
    id_type,
    id_u,
    id_ui_alias,
    id_ui_anim_editable,
    id_ui_comment,
    id_ui_default_max,
    id_ui_default_min,
    id_ui_editable,
    id_ui_group,
    id_ui_item,
    id_ui_max,
    id_ui_min,
    id_ui_label,
    id_ui_order,
    id_ui_visible,
    id_uniform_var,
    id_uniform_var_array,
    id_buffer_var,
    id_buffer_var_array,
    id_unite_pos_quantize,
    id_user_data,
    id_user_data_array,
    id_user_float,
    id_user_int,
    id_user_stream,
    id_user_string,
    id_user_wstring,
    id_v,
    id_value,
    id_variation,
    id_variation_array,
    id_varying,
    id_version,
    id_vertex,
    id_vertex_array,
    id_vertex_index,
    id_vertex_shader,
    id_vertex_shape_anim,
    id_vertex_shape_anim_array,
    id_vertex_skinning_count,
    id_vertex_stage,
    id_vertex_symbol,
    id_visibility,
    id_vtx_attrib,
    id_vtx_attrib_array,
    id_vtx_buffer,
    id_vtx_buffer_array,
    id_w,
    id_width,
    id_wrap,
    id_write,
    id_wstring,
    id_nn_tex_pattern_anim,				//!< nn 版では変更があるので再定義
    id_nn_tex_pattern_anim_array,
    id_nn_material_visibility_anim,
    id_nn_param_anim,					//!< nn 版で変更はないが _array 版の名前が違うので定義を追加します。
    id_nn_param_anim_array,
    id_nn_material_anim,
    id_nn_material_anim_info,
    id_nn_per_material_anim,
    id_nn_per_material_anim_array,
    id_nn_original_per_material_anim,
    id_nn_original_per_material_anim_array,
    num_identifier
};

extern const util::LiteralStr tbl_identifier[];

extern const char* GetIdentifierName( Identifier id );

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
