﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Reflection;
using System.Resources;

namespace nw.g3d
{
    /// <summary>
    /// 実行ファイルの文字列
    /// </summary>
    public static class Strings
    {
        /// <summary>
        /// 初期化
        /// </summary>
        /// <param name="resourcePath">文字列リソースへのパス</param>
        public static void Initialize(string resourcePath)
        {
            _resouceManager = new ResourceManager(
                resourcePath,
                Assembly.GetEntryAssembly() ?? Assembly.GetCallingAssembly());
        }

        /// <summary>
        /// 文字列の取得
        /// </summary>
        /// <param name="id">文字列識別子</param>
        /// <param name="args">書式指定引数</param>
        /// <returns>文字列</returns>
        public static string Get(string id, params object[] args)
        {
            if (_resouceManager == null)
            {
                throw new Exception("String resource not initialized. [" + id + "]");
            }

            string resource = _resouceManager.GetString(id);
            if (resource == null)
            {
                throw new Exception("String resource not found. [" + id + "]");
            }

            return string.Format(resource, args);
        }

        /// <summary>
        /// 例外の送出
        /// </summary>
        /// <param name="id">文字列識別子</param>
        /// <param name="args">書式指定引数</param>
        public static void Throw(string id, params object[] args)
        {
            throw new Exception(Strings.Get(id, args));
        }

        private static ResourceManager _resouceManager = null;
    }
}
