﻿#----------------------------------------------------------------------------
# Project:  NintendoWare
#
# Copyright (C)Nintendo All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.
#----------------------------------------------------------------------------

# 中間ファイルの更新、System.Xml.XmlDocument 型の doc を更新します
def Update(doc):
	# <nw4f_3dif> version を 1.0.0 に変更します。
	version = doc.SelectSingleNode("/nw4f_3dif/@version")
	version.Value = "1.0.0"

	# optimize_log の更新
	UpdateOptimizeLog(doc)

	# モデルの更新
	if doc.SelectSingleNode("/nw4f_3dif/model"):
		UpdateModel(doc)

	# テクスチャの更新
	elif doc.SelectSingleNode("/nw4f_3dif/texture"):
		UpdateTexture(doc)

	# スケルタルアニメの更新
	elif doc.SelectSingleNode("/nw4f_3dif/skeletal_anim"):
		UpdateSkeletalAnim(doc)

	# シェーダパラメータアニメの更新
	elif doc.SelectSingleNode("/nw4f_3dif/shader_param_anim"):
		UpdateShaderParamAnim(doc)

	# テクスチャパターンアニメの更新
	elif doc.SelectSingleNode("/nw4f_3dif/tex_pattern_anim"):
		UpdateTexPatternAnim(doc)

	# ボーンビジビリティアニメの更新
	elif doc.SelectSingleNode("/nw4f_3dif/bone_visibility_anim"):
		UpdateBoneVisibilityAnim(doc)

	# マテリアルビジビリティアニメの更新
	elif doc.SelectSingleNode("/nw4f_3dif/mat_visibility_anim"):
		UpdateMaterialVisibilityAnim(doc)

#----------------------------------------------------------
# optimize_log の更新
def UpdateOptimizeLog(doc):
	# <optimize_log> の result を要素の内容に移動します。
	for optimize_log in doc.SelectNodes("//optimize_log"):
		result = optimize_log.GetAttribute("result")
		optimize_log.RemoveAttribute("result");
		optimize_log.InnerText = "\r\n\t\t" + result + "\r\n\t"

#==========================================================
# モデルの更新
def UpdateModel(doc):
	# <shader_option> の option_name を id に変更します。
	for shader_option in doc.SelectNodes("//shader_option"):
		option_name = shader_option.GetAttribute("option_name")
		shader_option.RemoveAttribute("option_name")
		shader_option.SetAttribute("id", option_name)

	# <shape_info> に以下の属性を追加します。
	for shape_info in doc.SelectNodes(
		"/nw4f_3dif/model/shape_array/shape/shape_info"):

		# optimize_primitive_mode を "none" で追加します。
		shape_info.SetAttribute("optimize_primitive_mode", "none")

		# optimize_primitive_hash を空文字列で追加します。
		shape_info.SetAttribute("optimize_primitive_hash", "")

		# binarize_adjacency を "false" で追加します。
		shape_info.SetAttribute("binarize_adjacency", "false")

#==========================================================
# テクスチャの更新
def UpdateTexture(doc):
	texture_info = doc.SelectSingleNode("/nw4f_3dif/texture/texture_info")

	# <texture_info> に comp_sel を quantize_type に合わせた値で追加します。
	quantize_type = texture_info.GetAttribute("quantize_type")
	comp_sel = "r g b a"
	if ((quantize_type == "unorm_8") or
		(quantize_type == "snorm_8") or
		(quantize_type == "unorm_bc4") or
		(quantize_type == "snorm_bc4")):
		comp_sel = "r r r 1"
	elif ((quantize_type == "unorm_8_8") or
		(quantize_type == "snorm_8_8") or
		(quantize_type == "unorm_bc5") or
		(quantize_type == "snorm_bc5")):
		comp_sel = "r g 0 1"
	elif (quantize_type == "unorm_5_6_5"):
		comp_sel = "r g b 1"
	texture_info.SetAttribute("comp_sel", comp_sel)

	# <texture_info> に weighted_compress を "true" で追加します。
	texture_info.SetAttribute("weighted_compress", "true")

#==========================================================
# スケルタルアニメの更新
def UpdateSkeletalAnim(doc):
	# カーブの更新
	UpdateCurve(doc)

	# <skeletal_anim_info> に以下の属性を追加します。
	skeletal_anim_info = doc.SelectSingleNode("/nw4f_3dif/skeletal_anim/skeletal_anim_info")
	UpdateAnimInfo(skeletal_anim_info)

	# bake_tolerance_scale を "0.01" で追加します。
	skeletal_anim_info.SetAttribute("bake_tolerance_scale", "0.01")

	# bake_tolerance_rotate を "0.1" で追加します。
	skeletal_anim_info.SetAttribute("bake_tolerance_rotate", "0.1")

	# bake_tolerance_translate を "0.01" で追加します。
	skeletal_anim_info.SetAttribute("bake_tolerance_translate", "0.01")

	# quantize_tolerance_scale を "0.01" で追加します。
	skeletal_anim_info.SetAttribute("quantize_tolerance_scale", "0.01")

	# quantize_tolerance_rotate を "0.2" で追加します。
	skeletal_anim_info.SetAttribute("quantize_tolerance_rotate", "0.2")

	# quantize_tolerance_translate を "0.01" で追加します。
	skeletal_anim_info.SetAttribute("quantize_tolerance_translate", "0.01")

	# <skeletal_anim_info> から scale_enable を削除します。
	skeletal_anim_info.RemoveAttribute("scale_enable")

#==========================================================
# シェーダパラメータアニメの更新
def UpdateShaderParamAnim(doc):
	# カーブの更新
	UpdateCurve(doc)

	# <shader_param_anim_info> に以下の属性を追加します。
	shader_param_anim_info = doc.SelectSingleNode(
		"/nw4f_3dif/shader_param_anim/shader_param_anim_info")
	UpdateAnimInfo(shader_param_anim_info)

	# shader_assigned を、<shader_param_mat_anim_array> が存在すれば "true"、存在しなければ "false" で追加します。
	if doc.SelectSingleNode(
		"/nw4f_3dif/shader_param_anim/shader_param_mat_anim_array"):
		shader_param_anim_info.SetAttribute("shader_assigned", "true")
	else:
		shader_param_anim_info.SetAttribute("shader_assigned", "false")

	# bake_tolerance_color を "0.001" で追加します。
	shader_param_anim_info.SetAttribute("bake_tolerance_color", "0.001")

	# bake_tolerance_tex_scale を "0.01" で追加します。
	shader_param_anim_info.SetAttribute("bake_tolerance_tex_scale", "0.01")

	# bake_tolerance_tex_rotate を "0.1" で追加します。
	shader_param_anim_info.SetAttribute("bake_tolerance_tex_rotate", "0.1")

	# bake_tolerance_tex_translate を "0.01" で追加します。
	shader_param_anim_info.SetAttribute("bake_tolerance_tex_translate", "0.01")

	# quantize_tolerance_tex_scale を "0.01" で追加します。
	shader_param_anim_info.SetAttribute("quantize_tolerance_tex_scale", "0.01")

	# quantize_tolerance_tex_rotate を "0.2" で追加します。
	shader_param_anim_info.SetAttribute("quantize_tolerance_tex_rotate", "0.2")

	# quantize_tolerance_tex_translate を "0.01" で追加します。
	shader_param_anim_info.SetAttribute("quantize_tolerance_tex_translate", "0.01")

	# <original_hermite>、<original_linear>、<original_step> に baked を "false" で追加します。
	for original_hermite in doc.SelectNodes("//original_hermite"):
		original_hermite.SetAttribute("baked", "false");

	for original_linear in doc.SelectNodes("//original_linear"):
		original_linear.SetAttribute("baked", "false");

	for original_step in doc.SelectNodes("//original_step"):
		original_step.SetAttribute("baked", "false");

#==========================================================
# テクスチャパターンアニメの更新
def UpdateTexPatternAnim(doc):
	# カーブの更新
	UpdateCurve(doc)

	# <tex_pattern_anim_info> に以下の属性を追加します。
	tex_pattern_anim_info = doc.SelectSingleNode(
		"/nw4f_3dif/tex_pattern_anim/tex_pattern_anim_info")
	UpdateAnimInfo(tex_pattern_anim_info)

#==========================================================
# ボーンビジビリティアニメの更新
def UpdateBoneVisibilityAnim(doc):
	# カーブの更新
	UpdateCurve(doc)

	# <bone_visibility_anim_info> に以下の属性を追加します。
	bone_visibility_anim_info = doc.SelectSingleNode(
		"/nw4f_3dif/bone_visibility_anim/bone_visibility_anim_info")
	UpdateAnimInfo(bone_visibility_anim_info)

	# <bone_vis_bone_anim> に binarize_visibility を "true" で追加します。
	for bone_vis_bone_anim in doc.SelectNodes(
		"/nw4f_3dif/bone_visibility_anim/bone_vis_bone_anim_array/bone_vis_bone_anim"):
		bone_vis_bone_anim.SetAttribute("binarize_visibility", "true")

#==========================================================
# マテリアルビジビリティアニメの更新
def UpdateMaterialVisibilityAnim(doc):
	# カーブの更新
	UpdateCurve(doc)

	# <mat_visibility_anim_info> に以下の属性を追加します。
	mat_visibility_anim_info = doc.SelectSingleNode(
		"/nw4f_3dif/mat_visibility_anim/mat_visibility_anim_info")
	UpdateAnimInfo(mat_visibility_anim_info)

#==========================================================
# カーブの更新
def UpdateCurve(doc):
	# <hermite_curve>、<linear_curve>、<step_curve> に baked を "false" で追加します。
	for hermite_curve in doc.SelectNodes("//hermite_curve"):
		hermite_curve.SetAttribute("baked", "false");

	for linear_curve in doc.SelectNodes("//linear_curve"):
		linear_curve.SetAttribute("baked", "false");

	for step_curve in doc.SelectNodes("//step_curve"):
		step_curve.SetAttribute("baked", "false");

#----------------------------------------------------------
def UpdateAnimInfo(anim_info):
	# frame_resolution を "1" で追加します
	anim_info.SetAttribute("frame_resolution", "1")

	# bake_all を "false" で追加します。
	anim_info.SetAttribute("bake_all", "false")

	# quantize_tolerance_frame を "0.5" で追加します。
	anim_info.SetAttribute("quantize_tolerance_frame", "0.5")

#==========================================================
