﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef Utility_H_
#define Utility_H_

using namespace System;
using namespace System::Drawing;
using namespace System::Drawing::Imaging;
using namespace System::Collections::Generic;
using namespace nw::g3d::nw4f_3dif;

namespace TexUtils
{

// linear系
void Decode_unorm_8(			unsigned char *dstColor, const unsigned char *src, int size, const unsigned char *gammaCorrectTable[4]);
void Decode_snorm_8(			unsigned char *dstColor, const unsigned char *src, int size, const unsigned char *gammaCorrectTable[4]);
void Decode_unorm_4_4(			unsigned char *dstColor, const unsigned char *src, int size, const unsigned char *gammaCorrectTable[4]);
void Decode_unorm_8_8(			unsigned char *dstColor, const unsigned char *src, int size, const unsigned char *gammaCorrectTable[4]);
void Decode_snorm_8_8(			unsigned char *dstColor, const unsigned char *src, int size, const unsigned char *gammaCorrectTable[4], bool isHintNormal);
void Decode_unorm_5_6_5(		unsigned char *dstColor, const unsigned char *src, int size, const unsigned char *gammaCorrectTable[4]);
void Decode_unorm_5_5_5_1(		unsigned char *dstColor, const unsigned char *src, int size, const unsigned char *gammaCorrectTable[4]);
void Decode_unorm_4_4_4_4(		unsigned char *dstColor, const unsigned char *src, int size, const unsigned char *gammaCorrectTable[4]);
void Decode_unorm_8_8_8_8(		unsigned char *dstColor, const unsigned char *src, int size, const unsigned char *gammaCorrectTable[4]);
void Decode_snorm_8_8_8_8(		unsigned char *dstColor, const unsigned char *src, int size, const unsigned char *gammaCorrectTable[4]);
void Decode_float_16(			unsigned char *dstColor, const unsigned char *src, int size, const unsigned char *gammaCorrectTable[4]);
void Decode_float_32(			unsigned char *dstColor, const unsigned char *src, int size, const unsigned char *gammaCorrectTable[4]);
void Decode_float_16_16(		unsigned char *dstColor, const unsigned char *src, int size, const unsigned char *gammaCorrectTable[4]);
void Decode_float_32_32(		unsigned char *dstColor, const unsigned char *src, int size, const unsigned char *gammaCorrectTable[4]);
void Decode_float_11_11_10(		unsigned char *dstColor, const unsigned char *src, int size, const unsigned char *gammaCorrectTable[4]);
void Decode_float_16_16_16_16(	unsigned char *dstColor, const unsigned char *src, int size, const unsigned char *gammaCorrectTable[4]);
void Decode_float_32_32_32_32(	unsigned char *dstColor, const unsigned char *src, int size, const unsigned char *gammaCorrectTable[4]);

// bc系
void Decode_unorm_bc1(			unsigned char *dst, const unsigned char *src, int x, int y, int dstStride);
void Decode_unorm_bc2(			unsigned char *dst, const unsigned char *src, int x, int y, int dstStride);
void Decode_unorm_bc3(			unsigned char *dst, const unsigned char *src, int x, int y, int dstStride);
void Decode_unorm_bc4(			unsigned char *dst, const unsigned char *src, int x, int y, int dstStride);
void Decode_snorm_bc4(			unsigned char *dst, const unsigned char *src, int x, int y, int dstStride);
void Decode_unorm_bc5(			unsigned char *dst, const unsigned char *src, int x, int y, int dstStride);
void Decode_snorm_bc5(			unsigned char *dst, const unsigned char *src, int x, int y, int dstStride, bool isHintNormal);

// linear系
void Decode_unorm_8(			Byte *dstByteColor, const Byte *src, int size);
void Decode_snorm_8(			Byte *dstByteColor, const Byte *src, int size);
void Decode_unorm_4_4(			Byte *dstByteColor, const Byte *src, int size);
void Decode_unorm_8_8(			Byte *dstByteColor, const Byte *src, int size);
void Decode_snorm_8_8(			Byte *dstByteColor, const Byte *src, int size, bool isHintNormal);
void Decode_unorm_5_6_5(		Byte *dstByteColor, const Byte *src, int size);
void Decode_unorm_5_5_5_1(		Byte *dstByteColor, const Byte *src, int size);
void Decode_unorm_4_4_4_4(		Byte *dstByteColor, const Byte *src, int size);
void Decode_unorm_8_8_8_8(		Byte *dstByteColor, const Byte *src, int size);
void Decode_snorm_8_8_8_8(		Byte *dstByteColor, const Byte *src, int size);

// float を直返す
void Decode_float_16(			float *dstByteColor, const Byte *src, int size);
void Decode_float_32(			float *dstByteColor, const Byte *src, int size);
void Decode_float_16_16(		float *dstByteColor, const Byte *src, int size);
void Decode_float_32_32(		float *dstByteColor, const Byte *src, int size);
void Decode_float_11_11_10(		float *dstByteColor, const Byte *src, int size);
void Decode_float_16_16_16_16(	float *dstByteColor, const Byte *src, int size);
void Decode_float_32_32_32_32(	float *dstByteColor, const Byte *src, int size);

}	// namespace TexUtils

#endif // Utility_H_
