﻿using nw.g3d.toollib;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TextureCompositor
{
    public static class TextureUtility
    {
        public static string FindTexturePath(string texName, IEnumerable<string> texRefPaths)
        {
            foreach (string folder in texRefPaths)
            {
                var path = System.IO.Path.Combine(folder, $"{texName}.ftxb");
                if (System.IO.File.Exists(path))
                {
                    return path;
                }
            }

            return string.Empty;
        }

        public static string Get3dTextureConverterPath()
        {
            return System.IO.Path.Combine(G3dToolUtility.GetG3dToolRootPath(), "3dTextureConverter.exe");
        }

        public static void ConvertTexture(string converterOptions)
        {
            Utility.ExecuteProcess(
                TextureUtility.Get3dTextureConverterPath(),
                converterOptions,
                x => Logger.Instance.WriteMessageLine(x),
                x => Logger.Instance.WriteErrorMessageLine(x));
        }
    }
}
