﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Xml;

namespace nw.g3d.nw4f_3dif
{
    /// <summary>
    /// ストリームへの参照
    /// </summary>
    public interface IG3dStreamReference
    {
        /// <summary>
        /// ストリームインデックス
        /// </summary>
        int stream_index { get; set; }
    }

    //=====================================================================
    public partial class user_streamType : IG3dStreamReference { }

    public partial class vtx_attribType : IG3dStreamReference { }

    public partial class meshType : IG3dStreamReference { }

    public partial class texture_infoType : IG3dStreamReference { }

    public partial class original_imageType : IG3dStreamReference { }

    public partial class hermite_curveType : IG3dStreamReference { }

    public partial class linear_curveType : IG3dStreamReference { }

    public partial class step_curveType : IG3dStreamReference { }

    public partial class original_hermiteType : IG3dStreamReference { }

    public partial class original_linearType : IG3dStreamReference { }

    public partial class original_stepType : IG3dStreamReference { }

    public partial class shader_srcType : IG3dStreamReference { }
}
