﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Globalization;
using System.IO;
using System.Reflection;
using System.Threading;

namespace nw.g3d.nw4f_3dif
{
    /// <summary>
    /// ローカライズ
    /// </summary>
    public static class G3dLocalization
    {
        /// <summary>
        /// カルチャ
        /// </summary>
        public enum Culture
        {
            /// <summary>
            /// 日本語
            /// </summary>
            ja_jp,
            /// <summary>
            /// 英語
            /// </summary>
            en_us,
        }

        /// <summary>
        /// カルチャの設定
        /// </summary>
        public static void SetCulture()
        {
            string entoryFolder = Path.GetDirectoryName((Assembly.GetEntryAssembly() ?? Assembly.GetCallingAssembly()).Location);
            if (Directory.Exists(Path.Combine(entoryFolder, "en")))
            {
                CultureInfo cultureInfo = CultureInfo.CreateSpecificCulture("en-us");
                Thread.CurrentThread.CurrentCulture = cultureInfo;
                Thread.CurrentThread.CurrentUICulture = cultureInfo;
                G3dLocalization.CurrentCulture = Culture.en_us;
            }
        }

        /// <summary>
        /// カレントカルチャ
        /// </summary>
        public static Culture CurrentCulture
        {
            get { return _currentCulture; }
            set { _currentCulture = value; }
        }

        private static Culture _currentCulture = Culture.ja_jp;
    }
}
