﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace nw4f.tinymathlib
{
    public class Vector4
    {
        private double[] mData = new double[4];

        /// <summary>
        /// インデクサ
        /// </summary>
        public double this[int index]
        {
            get { return mData[index]; }
            set { mData[index] = value; }
        }

        // prop X
        public double x
        {
            get { return mData[0]; }
            set { mData[0] = value; }
        }
        // prop Y
        public double y
        {
            get { return mData[1]; }
            set { mData[1] = value; }
        }
        // prop Z
        public double z
        {
            get { return mData[2]; }
            set { mData[2] = value; }
        }
        // prop W
        public double w
        {
            get { return mData[3]; }
            set { mData[3] = value; }
        }

        public VectorN ToVectorN()
        {
            var ret = new VectorN(4);
            ret[0] = x;
            ret[1] = y;
            ret[2] = z;
            ret[3] = w;
            return ret;
        }

        /// <summary>
        /// 値のコピーを行う
        /// </summary>
        public void Set(Vector4 rhs)
        {
            Array.Copy(rhs.mData, mData, 4);
        }
        /// <summary>
        /// ゼロ初期化
        /// </summary>
        public void SetZero()
        {
            mData[0] = 0;
            mData[1] = 0;
            mData[2] = 0;
            mData[3] = 0;
        }

        /// <summary>
        /// 減算
        /// </summary>
        /// <param name="rhs">引く数</param>
        /// <returns>結果</returns>
        public static Vector4 operator -(Vector4 lhs, Vector4 rhs)
        {
            Vector4 result = new Vector4();
            result.mData[0] = lhs.mData[0] - rhs.mData[0];
            result.mData[1] = lhs.mData[1] - rhs.mData[1];
            result.mData[2] = lhs.mData[2] - rhs.mData[2];
            return result;
        }

        /// <summary>
        /// 内積を取得
        /// </summary>
        public double Dot(Vector4 rhs)
        {
            return x * rhs.x + y * rhs.y + z * rhs.z + w * rhs.w;
        }

        /// <summary>
        /// ノルムを計算する
        /// </summary>
        /// <returns>ノルム</returns>
        public double Norm()
        {
            return Math.Sqrt(Dot(this));
        }
    }
}
