﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using nw.g3d.iflib;
using nw4f.tinymathlib;

namespace nw4f.meshlib
{
    internal partial class ClosedPropManager
    {
        /// <summary>
        /// （非汎用関数）力づくでインデックスを強引に揃えようとする
        /// </summary>
        /// <param name="mesh"></param>
        /// <param name="type"></param>
        /// <param name="name"></param>
        internal static void ReverseRun(Mesh mesh, SourceType type, string name)
        {
            MeshSourceBase source = mesh.GetSource(type, name);
            if (source == null) { return; }

            int refo = int.MaxValue;
            foreach (var si in mesh.Sources)
            {
                if (si.Type == type) { continue; }
                if (si.Type == SourceType.Position) { continue; }
                if (refo == int.MaxValue)
                {
                    refo = mesh.GetSourceOfset(si.Type, si.Name);
                }
            }
            if (refo == int.MaxValue)
            {
                refo = mesh.GetSourceOfset(SourceType.Position, null);
            }

            int offs = mesh.GetSourceOfset(type, name);
            int sn = mesh.SourceN;
            int[] hit = new int[source.Count];

            //-----------------------------------------------------
            // 使用状態チェッカ
            for (int i = 0; i < source.Count; i++)
            {
                hit[i] = int.MaxValue;
            }

            //-----------------------------------------------------
            // 使用状態をチェック
            for (int fi = 0; fi < mesh.FaceN; fi++)
            {
                if (mesh.IsInvalidateFace(fi)) { continue; }

                int vo = mesh.VOffset[fi];
                int vn = mesh.VNums[fi];
                for (int vi = 0; vi < vn; vi++)
                {
                    int pid = mesh.VBuffer[(vo + vi) * sn + offs];
                    hit[pid] = pid;
                }
            }

            //-----------------------------------------------------
            // 指定のソースが、Shapeに存在するか？を調べる
            Dictionary<int, bool> findSrc = new Dictionary<int, bool>();
            for (int fg = 0; fg < mesh.MaterialShapeInformationList.Count; fg++)
            {
                findSrc.Add(mesh.MaterialShapeInformationList[fg].Index, false);
                foreach (var info in mesh.MaterialShapeInformationList[fg].refSources)
                {
                    if (info.Item1 == type && info.Item2 == name)
                    {
                        findSrc[mesh.MaterialShapeInformationList[fg].Index] = true;
                        break;
                    }
                }
            }

            for (int fi = 0; fi < mesh.FaceN; fi++)
            {
                if (mesh.IsInvalidateFace(fi)) { continue; }

                int fg = mesh._FaceMaterialShapeID[fi];
                int vo = mesh.VOffset[fi];
                int vn = mesh.VNums[fi];

                for (int vi = 0; vi < vn; vi++)
                {
                    int rid = mesh.VBuffer[(vo + vi) * sn + refo];
                    int pid = mesh.VBuffer[(vo + vi) * sn + offs];
                    if (rid != pid && findSrc[fg])
                    {
                        if (hit[rid] != int.MaxValue)
                        {
                            throw ExcepHandle.CreateException("collide value was overwritten");
                        }

                        for (int si = 0; si < source.Stride; si++)
                        {
                            object sv = source.GetRowValue(pid * source.Stride + si);
                            source.SetRowValue(rid * source.Stride + si, sv);
                        }
                        mesh.VBuffer[(vo + vi) * sn + offs] = rid;
                    }
                    else if (!findSrc[fg])
                    {
                        mesh.VBuffer[(vo + vi) * sn + offs] = rid;
                    }
                }
            }
        }
    }
}
