﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace nw.g3d.iflib
{
    /// <summary>
    /// int 関連のユーティリティです。
    /// </summary>
    public static class IntUtility
    {
        /// <summary>
        /// int の値が偶数かどうかを示します。
        /// </summary>
        /// <param name="number">int の値です。</param>
        /// <returns>偶数の場合は true を返します。</returns>
        public static bool IsEven(int number)
        {
            return (number % 2) == 0;
        }

        /// <summary>
        /// 値を指定された範囲内に制限します。
        /// </summary>
        /// <param name="value">クランプする値です。</param>
        /// <param name="min">最小値です。</param>
        /// <param name="max">最大値です。</param>
        /// <returns>クランプされた値です。</returns>
        public static int Clamp(int value, int min, int max)
        {
            Ensure.Operation.True(min <= max);

            if (value < min)
            {
                return min;
            }

            if (max < value)
            {
                return max;
            }

            return value;
        }

        /// <summary>
        /// 値が指定された範囲内にあるか調べます。
        /// </summary>
        /// <param name="value">範囲チェックする値です。</param>
        /// <param name="min">最小値です。</param>
        /// <param name="max">最大値です。</param>
        /// <returns>範囲内であれば true を返します。</returns>
        public static bool Contains(int value, int min, int max)
        {
            Ensure.Operation.True(min <= max);

            if (value < min)
            {
                return false;
            }

            if (max < value)
            {
                return false;
            }

            return true;
        }
    }
}
