﻿using Nintendo.G3dTool.Entities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml;
using System.Xml.Schema;
using System.Xml.Serialization;

namespace nw.g3d.iflib.nw3de
{
    [Serializable]
    public class nw3de_MaterialReferenceBehavior : ToolDataObject
    {
        public List<MaterialReferenceBehavior> MaterialReferenceBehaviors { get; set; }

        public nw3de_MaterialReferenceBehavior()
        {
            MaterialReferenceBehaviors = new List<MaterialReferenceBehavior>();
        }

        public void ClearEmptyItems()
        {
            foreach (var behavior in MaterialReferenceBehaviors)
            {
                behavior.ClearEmptyItems();
            }
            MaterialReferenceBehaviors = MaterialReferenceBehaviors.Where(x => !x.Empty()).ToList();
        }

        public bool Updated
        {
            get { return MaterialReferenceBehaviors?.Any(x => x.Updated) == true; }
        }
    }

    [Serializable]
    public class MaterialReferenceBehavior
    {
        [XmlAttribute]
        public string MaterialName { get; set; } = string.Empty;

        [XmlArrayItem("ShaderParamBehavior")]
        public List<MaterialReferenceBehaviorItem> ShaderParamBehaviors { get; set; }

        [XmlArrayItem("RenderInfoBehavior")]
        public List<MaterialReferenceBehaviorItem> RenderInfoBehaviors { get; set; }

        [XmlArrayItem("SamplerAssignBehavior")]
        public List<MaterialReferenceBehaviorItem> SamplerAssignBehaviors { get; set; }

        [XmlArrayItem("ShaderOptionBehavior")]
        public List<MaterialReferenceBehaviorItem> ShaderOptionBehaviors { get; set; }

        [XmlArrayItem("AttribAssignBehavior")]
        public List<MaterialReferenceBehaviorItem> AttribAssignBehaviors { get; set; }

        public MaterialReferenceSamplerBehaviors SamplerBehaviors { get; set; }

        public MaterialReferenceBehavior()
        {
            ShaderParamBehaviors = new List<MaterialReferenceBehaviorItem>();
            RenderInfoBehaviors = new List<MaterialReferenceBehaviorItem>();
            SamplerAssignBehaviors = new List<MaterialReferenceBehaviorItem>();
            ShaderOptionBehaviors = new List<MaterialReferenceBehaviorItem>();
            AttribAssignBehaviors = new List<MaterialReferenceBehaviorItem>();
            SamplerBehaviors  = new MaterialReferenceSamplerBehaviors();
        }

        public void ClearEmptyItems()
        {
            if (ShaderParamBehaviors != null && !ShaderParamBehaviors.Any()) { ShaderParamBehaviors = null; }
            if (RenderInfoBehaviors != null && !RenderInfoBehaviors.Any()) { RenderInfoBehaviors = null; }
            if (SamplerAssignBehaviors != null && !SamplerAssignBehaviors.Any()) { SamplerAssignBehaviors = null; }
            if (ShaderOptionBehaviors != null && !ShaderOptionBehaviors.Any()) { ShaderOptionBehaviors = null; }
            if (AttribAssignBehaviors != null && !AttribAssignBehaviors.Any()) { AttribAssignBehaviors = null; }
            SamplerBehaviors?.ClearEmptyItems();
            if (SamplerBehaviors != null && SamplerBehaviors.Empty()) { SamplerBehaviors = null; }
        }

        public bool Empty()
        {
            return (ShaderParamBehaviors == null || !ShaderParamBehaviors.Any()) &&
                   (RenderInfoBehaviors == null || !RenderInfoBehaviors.Any()) &&
                   (SamplerAssignBehaviors == null || !SamplerAssignBehaviors.Any()) &&
                   (ShaderOptionBehaviors == null || !ShaderOptionBehaviors.Any()) &&
                   (AttribAssignBehaviors == null || !AttribAssignBehaviors.Any()) &&
                   (SamplerBehaviors == null || SamplerBehaviors.Empty());
        }

        public bool Updated
        {
            get
            {
                return ShaderParamBehaviors?.Any(x => x.Updated) == true ||
                       RenderInfoBehaviors?.Any(x => x.Updated) == true ||
                       SamplerAssignBehaviors?.Any(x => x.Updated) == true ||
                       ShaderOptionBehaviors?.Any(x => x.Updated) == true ||
                       AttribAssignBehaviors?.Any(x => x.Updated) == true ||
                       SamplerBehaviors?.SamplerBehaviorItems?.Any(x => x.Updated) == true;
            }
        }
    }
}
