﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nw.g3d.nw4f_3dif;
using System.Security.Cryptography;
using System.IO;
using System.Diagnostics;

namespace nw.g3d.iflib
{
    public static class IfOptimizePrimitiveHashCalculator
    {
        public static string Calculate(
            modelType model, List<G3dStream> streams, shapeType shape)
        {
            string result;
            if (model.vertex_array == null ||
                model.vertex_array.vertex == null) { return string.Empty; }

            using (MemoryStream stream = new MemoryStream())
            using (BinaryWriter writer = new BinaryWriter(stream))
            {
                // インデックス列をハッシュにする
                WriteStream(writer, streams[shape.mesh_array.mesh[0].stream_index]);

                // アトリビュート列をハッシュにする
                // <mesh> と <input> の quantize_type マージにも利用しているので注意
                vertexType vertex = model.vertex_array.vertex[shape.shape_info.vertex_index];
                foreach (vtx_attribType vtx_attrib in vertex.vtx_attrib_array.vtx_attrib)
                {
                    WriteStream(writer, streams[vtx_attrib.stream_index]);
                }
                stream.Close();
                byte[] data = stream.ToArray();

                // 入出力や最適化の時間と比べれば十分に小さいので SHA512Managed
                //result = ComputeHash(new MD5CryptoServiceProvider(), data); // 33ms
                //result = ComputeHash(new SHA1CryptoServiceProvider(), data); // 39ms
                //result = ComputeHash(new SHA1Managed(), data); // 119ms
                //result = ComputeHash(new SHA256Managed(), data); // 472ms
                result = ComputeHash(new SHA512Managed(), data); // 1071ms
            }
            return result;
        }

        private static void WriteStream(BinaryWriter writer, G3dStream stream)
        {
            if (stream.type == stream_typeType.@int)
            {
                stream.IntData.ForEach(delegate (int value) { writer.Write(value); });
            }
            else if (stream.type == stream_typeType.@float)
            {
                stream.FloatData.ForEach(delegate (float value) { writer.Write(value); });
            }
            else
            {
                /// TODO: Exception
                Nintendo.Foundation.Contracts.Assertion.Operation.True(false);
            }
        }

        private static string ComputeHash(HashAlgorithm algorithm, byte[] data)
        {
            //Stopwatch sw = new Stopwatch();
            //sw.Start();
            byte[] hash = algorithm.ComputeHash(data);
            string result = Convert.ToBase64String(hash);
            //sw.Stop();
            //Debug.WriteLine("{0}ms {1}bytes {2} {3}",
            //    sw.ElapsedMilliseconds, hash.Length, algorithm.GetType().Name, result);
            return result;
        }
    }
}
