﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // シェイプアニメーションマージャ
    public static class IfShapeAnimMerger
    {
        // マージ
        public static void Merge(
            shape_animType newShapeAnim,
            List<G3dStream> newStream,
            shape_animType oldShapeAnim,
            List<G3dStream> oldStream)
        {
            // <user_data_array> <tool_data> <user_tool_data> <comment>
            IfMergeUtility.MergeRootObject(
                newShapeAnim, oldShapeAnim,
                newStream, oldStream);

            // 使用されていないストリームを削除し、
            // 残ったストリームを中間ファイルの出現順にソートする。
            StreamUtility.SortStream(newShapeAnim, newStream);
        }
    }
}
