﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // マテリアルビジビリティアニメーションマージャ
    public static class IfMatVisibilityAnimMerger
    {
        // マージ用の情報
        public class IfMatVisibilityAnimMergerInfo
        {
            public IEnumerable<IfMergeSrcDstPair> MaterialNamePairTable{ get; set; }
        }

        // マージ
        public static void Merge(
            mat_visibility_animType newMatVisAnim,
            List<G3dStream> newStreams,
            mat_visibility_animType oldMatVisibilityAnim,
            List<G3dStream> oldStreams)
        {
            Merge(newMatVisAnim, newStreams, oldMatVisibilityAnim, oldStreams, null);
        }

        // オプション付きマージ
        public static void Merge(
            mat_visibility_animType newMatVisAnim,
            List<G3dStream> newStreams,
            mat_visibility_animType oldMatVisibilityAnim,
            List<G3dStream> oldStreams,
            IfMatVisibilityAnimMergerInfo info)
        {
            // <user_data_array> <tool_data> <user_tool_data> <comment>
            IfMergeUtility.MergeRootObject(
                newMatVisAnim, oldMatVisibilityAnim,
                newStreams, oldStreams);

            // マテリアルビジビリティアニメーションがないと処理を行わない
            if (oldMatVisibilityAnim.mat_vis_mat_anim_array == null ||
                oldMatVisibilityAnim.mat_vis_mat_anim_array.mat_vis_mat_anim == null)
            {
                return;
            }

            if (newMatVisAnim.mat_vis_mat_anim_array == null)
            {
                newMatVisAnim.mat_vis_mat_anim_array =
                    new mat_vis_mat_anim_arrayType();
            }

            // マテリアルアニメーションはカーブをつけたアニメーションしか出力しないので、
            // newMatVisAnim 側に無い mat_name を持つ oldMatVisibilityAnim をマージする

            // <mat_vis_mat_anim> のテーブルを作成する
            // キーとして oldMatVisibilityAnim 内の <mat_vis_mat_anim> を、値としてキーと同じ
            // mat_name を持つ newMatVisAnim 内の <mat_vis_mat_anim> を格納する。
            Dictionary<mat_vis_mat_animType, mat_vis_mat_animType> matVisMatTable =
                new Dictionary<mat_vis_mat_animType, mat_vis_mat_animType>();
            if (newMatVisAnim.mat_vis_mat_anim_array.mat_vis_mat_anim != null)
            {
                IfMergeUtility.SetupTableByFunc<mat_vis_mat_animType>(
                    matVisMatTable,
                    oldMatVisibilityAnim.mat_vis_mat_anim_array.mat_vis_mat_anim,
                    newMatVisAnim.mat_vis_mat_anim_array.mat_vis_mat_anim,
                    delegate(mat_vis_mat_animType newObject, mat_vis_mat_animType oldObject)
                    {
                        return (newObject.mat_name == oldObject.mat_name);
                    });
            }

            // 新しい mat_vis_mat_animType の配列を作成する
            List<mat_vis_mat_animType> newMatVisMatArray = new List<mat_vis_mat_animType>();
            if (newMatVisAnim.mat_vis_mat_anim_array.mat_vis_mat_anim != null)
            {
                foreach (var matVis in newMatVisAnim.mat_vis_mat_anim_array.mat_vis_mat_anim)
                {
                    newMatVisMatArray.Add(matVis);
                }
            }

            foreach (mat_vis_mat_animType oldMatVisMat in
                oldMatVisibilityAnim.mat_vis_mat_anim_array.mat_vis_mat_anim)
            {
                // newMatVisAnim にあるアニメーションは残す
                if (matVisMatTable.ContainsKey(oldMatVisMat))
                {
                    continue;
                }

                // <mat_vis_mat_anim> をコピーする
                mat_vis_mat_animType newMatVisMat =
                    CopyMatVisMatAnim(oldMatVisMat, newStreams, oldStreams);
                newMatVisMatArray.Add(newMatVisMat);
            }
            // <mat_vis_mat_anim> をマテリアル名順にソートする
            newMatVisMatArray.Sort(
                delegate(mat_vis_mat_animType lhs, mat_vis_mat_animType rhs)
                {
                    return string.CompareOrdinal(lhs.mat_name, rhs.mat_name);
                });
            for (int i = 0; i < newMatVisMatArray.Count; i++)
            {
                newMatVisMatArray[i].index = i;
            }

            // mat_vis_mat_animType 配列を入れ替える
            newMatVisAnim.mat_vis_mat_anim_array.length =
                newMatVisMatArray.Count;
            newMatVisAnim.mat_vis_mat_anim_array.mat_vis_mat_anim =
                newMatVisMatArray.ToArray();

            // ストリームを中間ファイルの出現順にソートする
            StreamUtility.SortStream(newMatVisAnim, newStreams);
        }

        // mat_vis_mat_animType をコピーする
        private static mat_vis_mat_animType CopyMatVisMatAnim(
            mat_vis_mat_animType oldMatVisMatAnim,
            List<G3dStream> newStream,
            List<G3dStream> oldStream)
        {
            mat_vis_mat_animType newMatVisMatAnim = new mat_vis_mat_animType();

            newMatVisMatAnim.mat_name = oldMatVisMatAnim.mat_name;
            newMatVisMatAnim.base_value = oldMatVisMatAnim.base_value;
            // インデックスは mat_vis_mat_animType のソート後に設定されるので、
            // ここではコピーしない。

            // カーブをコピーする
            if (oldMatVisMatAnim.Curve != null)
            {
                newMatVisMatAnim.Curve =
                    IfMergeUtility.CopyCurve(oldMatVisMatAnim.Curve);
                // ストリームをコピーする
                // ストリームは oldCurve から newStream に追加し、
                // 追加されたインデックスをカーブの stream_index に設定する。
                newMatVisMatAnim.Curve.stream_index = newStream.Count;
                newStream.Add(oldStream[oldMatVisMatAnim.Curve.stream_index]);
            }

            return newMatVisMatAnim;
        }
    }
}
