﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Diagnostics;
using System.IO;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // テキストテクスチャ中間ファイルフォーマッタ
    internal static class IfTextTextureFormatter
    {
        // texture のフォーマット
        internal static void Format(TextReader rd, TextWriter wt)
        {
            // texture
            wt.WriteLine($"<{G3dConstant.TextureElementName} {rd.ReadLine()}");

            // process_log
            string process_log_array = rd.ReadLine();
            string texture_info;
            if (process_log_array == "<process_log_array")
            {
                IfTextFormatterUtility.Format_process_log_array(rd, wt);
                texture_info = rd.ReadLine();
            }
            else
            {
                texture_info = process_log_array;
            }

            // texture_info
            Nintendo.Foundation.Contracts.Assertion.Operation.True(texture_info == "<texture_info");
            FormatTextureInfo(rd, wt);

            // original_image
            string original_image_array = rd.ReadLine();
            string user_data_array;
            if (original_image_array == "<original_image_array")
            {
                FormatOriginalImage(rd, wt);
                user_data_array = rd.ReadLine();
            }
            else
            {
                user_data_array = original_image_array;
            }

            // user_data
            string stream_array;
            if (user_data_array == "<user_data_array")
            {
                IfTextFormatterUtility.Format_user_data_array(rd, wt, string.Empty);
                stream_array = rd.ReadLine();
            }
            else
            {
                stream_array = user_data_array;
            }

            // stream
            string comment;
            if (stream_array == "<stream_array")
            {
                IfTextFormatterUtility.Format_stream(rd, wt);
                comment = rd.ReadLine();
            }
            else
            {
                comment = stream_array;
            }

            // comment
            string tool_data;
            if (comment == "<comment")
            {
                IfTextFormatterUtility.FormatComment(rd, wt, string.Empty);
                tool_data = rd.ReadLine();
            }
            else
            {
                tool_data = comment;
            }

            // tool_data
            string user_tool_data;
            if (tool_data == "<tool_data>")
            {
                IfTextFormatterUtility.FormatToolData(rd, wt, string.Empty);
                user_tool_data = rd.ReadLine();
            }
            else
            {
                user_tool_data = tool_data;
            }

            // user_tool_data
            string close_texture;
            if (user_tool_data == "<user_tool_data>")
            {
                IfTextFormatterUtility.FormatUserToolData(rd, wt, string.Empty);
                close_texture = rd.ReadLine();
            }
            else
            {
                close_texture = user_tool_data;
            }

            Nintendo.Foundation.Contracts.Assertion.Operation.True(close_texture == "</texture>");
            wt.WriteLine(close_texture);
        }

        //---------------------------------------------------------------------
        #region texture_info
        // texture_info のフォーマット
        private static void FormatTextureInfo(TextReader rd, TextWriter wt)
        {
            // texture_info
            wt.WriteLine("<texture_info");
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0} {1} {2}", rd.ReadLine(), rd.ReadLine(), rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", IfTextFormatterUtility.RemoveSlashBracket(rd.ReadLine()));
            wt.WriteLine("/>");
        }
        #endregion

        //---------------------------------------------------------------------
        #region original_image
        // original_image のフォーマット
        private static void FormatOriginalImage(TextReader rd, TextWriter wt)
        {
            // original_image_array
            wt.WriteLine($"<original_image_array {rd.ReadLine()}");

            while (true)
            {
                // original_image
                string original_image = rd.ReadLine();
                if (original_image != "<original_image")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(original_image == "</original_image_array>");
                    wt.WriteLine("{0}", original_image);
                    break;
                }

                wt.WriteLine("\t{0} {1}",
                    original_image, rd.ReadLine());
                wt.WriteLine("\t\t{0}", rd.ReadLine());
                wt.WriteLine("\t\t{0}", rd.ReadLine());
                wt.WriteLine("\t\t{0}", rd.ReadLine());
                wt.WriteLine("\t\t{0} {1}", rd.ReadLine(), rd.ReadLine());
                wt.WriteLine("\t\t{0}", rd.ReadLine());
                wt.WriteLine("\t\t{0}", rd.ReadLine());
                wt.WriteLine("\t\t{0}",
                    IfTextFormatterUtility.RemoveSlashBracket(rd.ReadLine()));
                wt.WriteLine("\t/>");
            }
        }

        #endregion
    }
}
