﻿using System.Diagnostics;
using System.IO;

using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // マテリアルアニメーション中間ファイルフォーマッタ
    internal static class IfTextMaterialAnimFormatter
    {
        // material_anim のフォーマット
        internal static void Format(TextReader rd, TextWriter wt)
        {
            // material_anim
            wt.WriteLine($"<{G3dConstant.MaterialAnimElementName} {rd.ReadLine()}");

            // process_log
            var process_log_array = rd.ReadLine();
            string material_anim_info;
            if (process_log_array == "<process_log_array")
            {
                IfTextFormatterUtility.Format_process_log_array(rd, wt);
                material_anim_info = rd.ReadLine();
            }
            else
            {
                material_anim_info = process_log_array;
            }

            // material_anim_info
            Nintendo.Foundation.Contracts.Assertion.Operation.True(material_anim_info == "<material_anim_info");
            FormatMaterialAnimInfo(rd, wt);

            // tex_pattern
            var tex_pattern_array = rd.ReadLine();
            string per_material_anim_array;
            if (tex_pattern_array == "<tex_pattern_array")
            {
                IfTextTexPatternAnimFormatter.Format_tex_pattern(rd, wt);
                per_material_anim_array = rd.ReadLine();
            }
            else
            {
                per_material_anim_array = tex_pattern_array;
            }

            string original_per_material_anim_array;
            if (per_material_anim_array == "<per_material_anim_array")
            {
                Format_per_material_anim_array(rd, wt);
                original_per_material_anim_array = rd.ReadLine();
            }
            else
            {
                original_per_material_anim_array = per_material_anim_array;
            }

            // original_per_material_anim_array
            string user_data_array;
            if (original_per_material_anim_array == "<original_per_material_anim_array")
            {
                Format_original_per_material_anim(rd, wt);
                user_data_array = rd.ReadLine();
            }
            else
            {
                user_data_array = original_per_material_anim_array;
            }

            // user_data
            string stream_array;
            if (user_data_array == "<user_data_array")
            {
                IfTextFormatterUtility.Format_user_data_array(rd, wt, string.Empty);
                stream_array = rd.ReadLine();
            }
            else
            {
                stream_array = user_data_array;
            }

            // stream
            string comment;
            if (stream_array == "<stream_array")
            {
                IfTextFormatterUtility.Format_stream(rd, wt);
                comment = rd.ReadLine();
            }
            else
            {
                comment = stream_array;
            }

            // comment
            string tool_data;
            if (comment == "<comment")
            {
                IfTextFormatterUtility.FormatComment(rd, wt, string.Empty);
                tool_data = rd.ReadLine();
            }
            else
            {
                tool_data = comment;
            }

            // tool_data
            string user_tool_data;
            if (tool_data == "<tool_data>")
            {
                IfTextFormatterUtility.FormatToolData(rd, wt, string.Empty);
                user_tool_data = rd.ReadLine();
            }
            else
            {
                user_tool_data = tool_data;
            }

            // user_tool_data
            string close_material_anim;
            if (user_tool_data == "<user_tool_data>")
            {
                IfTextFormatterUtility.FormatUserToolData(rd, wt, string.Empty);
                close_material_anim = rd.ReadLine();
            }
            else
            {
                close_material_anim = user_tool_data;
            }

            Nintendo.Foundation.Contracts.Assertion.Operation.True(close_material_anim == "</material_anim>");
            wt.WriteLine(close_material_anim);
        }

        //---------------------------------------------------------------------
        #region material_anim_info
        // material_anim_info のフォーマット
        private static void FormatMaterialAnimInfo(TextReader rd, TextWriter wt)
        {
            // material_anim_info
            wt.WriteLine("<material_anim_info {0} {1}", rd.ReadLine(), rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", rd.ReadLine());
            wt.WriteLine("\t{0}", IfTextFormatterUtility.RemoveSlashBracket(rd.ReadLine()));
            wt.WriteLine("/>");
        }
        #endregion

        //---------------------------------------------------------------------
        #region per_material_anim_array
        // per_material_anim_array のフォーマット
        private static void Format_per_material_anim_array(TextReader rd, TextWriter wt)
        {
            // per_material_anim_array
            wt.WriteLine("<per_material_anim_array {0}", rd.ReadLine());

            while (true)
            {
                // per_material_anim
                var per_material_anim = rd.ReadLine();
                if (per_material_anim != "<per_material_anim")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(per_material_anim == "</per_material_anim_array>");
                    wt.WriteLine("{0}", per_material_anim);
                    break;
                }
                wt.WriteLine("\t{0} {1} {2}",
                    per_material_anim, rd.ReadLine(), rd.ReadLine());

                // shader_param_anim_array
                var shader_param_anim_array = rd.ReadLine();
                string tex_pattern_anim_array;
                if (shader_param_anim_array == "<shader_param_anim_array")
                {
                    Format_param_anim(rd, wt);
                    tex_pattern_anim_array = rd.ReadLine();
                }
                else
                {
                    tex_pattern_anim_array = shader_param_anim_array;
                }

                // tex_pattern_anim_array
                string material_visibility_anim;
                if (tex_pattern_anim_array == "<tex_pattern_anim_array")
                {
                    Format_pattern_anim(rd, wt);
                    material_visibility_anim = rd.ReadLine();
                }
                else
                {
                    material_visibility_anim = tex_pattern_anim_array;
                }

                // material_visibility_anim
                string close_per_material_anim;
                if (material_visibility_anim == "<material_visibility_anim")
                {
                    Format_material_visibility_anim(rd, wt);
                    close_per_material_anim = rd.ReadLine();
                }
                else
                {
                    close_per_material_anim = material_visibility_anim;
                }

                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_per_material_anim == "</per_material_anim>");
                wt.WriteLine("\t{0}", close_per_material_anim);
            }
        }

        private static void Format_material_visibility_anim(TextReader rd, TextWriter wt)
        {
            // tex_pattern_anim_array
            var base_value = rd.ReadLine();
            wt.WriteLine("\t\t<material_visibility_anim {0}", base_value);
            if (base_value.EndsWith(" />"))
            {
                return;
            }

            // step_curve
            string step_curve = rd.ReadLine();
            Nintendo.Foundation.Contracts.Assertion.Operation.True(step_curve == "<step_curve");
            IfTextFormatterUtility.Format_step_curve(rd, wt, "\t\t\t");

            string close_material_visibility_anim = rd.ReadLine();
            Nintendo.Foundation.Contracts.Assertion.Operation.True(close_material_visibility_anim == "</material_visibility_anim>");
            wt.WriteLine("\t\t{0}", close_material_visibility_anim);
        }

        private static void Format_pattern_anim(TextReader rd, TextWriter wt)
        {
            // tex_pattern_anim_array
            wt.WriteLine("\t\t<tex_pattern_anim_array {0}", rd.ReadLine());

            while (true)
            {
                // pattern_anim
                string pattern_anim = rd.ReadLine();
                if (pattern_anim != "<pattern_anim")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(pattern_anim == "</tex_pattern_anim_array>");
                    wt.WriteLine("\t\t{0}", pattern_anim);
                    break;
                }
                string name = rd.ReadLine();
                string hint = rd.ReadLine();
                string base_value = rd.ReadLine();
                wt.WriteLine("\t\t\t{0} {1} {2} {3}",
                    pattern_anim, name, hint, base_value);
                if (base_value.EndsWith(" />")) { continue; }

                // step_curve
                string step_curve = rd.ReadLine();
                Nintendo.Foundation.Contracts.Assertion.Operation.True(step_curve == "<step_curve");
                IfTextFormatterUtility.Format_step_curve(rd, wt, "\t\t\t\t");

                string close_pattern_anim_target = rd.ReadLine();
                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_pattern_anim_target == "</pattern_anim>");
                wt.WriteLine("\t\t\t{0}", close_pattern_anim_target);
            }
        }

        // param_anim のフォーマット
        private static void Format_param_anim(TextReader rd, TextWriter wt)
        {
            // shader_param_anim_array
            wt.WriteLine("\t\t<shader_param_anim_array {0}", rd.ReadLine());

            while (true)
            {
                // param_anim
                string param_anim = rd.ReadLine();
                if (param_anim != "<param_anim")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(param_anim == "</shader_param_anim_array>");
                    wt.WriteLine("\t\t{0}", param_anim);
                    break;
                }
                wt.WriteLine("\t\t\t{0} {1} {2} {3}",
                    param_anim, rd.ReadLine(), rd.ReadLine(), rd.ReadLine());
                wt.WriteLine("\t\t\t\t{0}", IfTextFormatterUtility.RemoveBracket(rd.ReadLine()));
                wt.WriteLine("\t\t\t>");

                string close_param_anim = IfTextShaderParamAnimFormatter.Format_param_anim_target(rd, wt);
                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_param_anim == "</param_anim>");
                wt.WriteLine("\t\t\t{0}", close_param_anim);
            }
        }

        #endregion

        //---------------------------------------------------------------------
        #region original_per_material_anim
        // original_per_material_anim のフォーマット
        private static void Format_original_per_material_anim(TextReader rd, TextWriter wt)
        {
            // original_per_material_anim
            wt.WriteLine("<original_per_material_anim_array {0}", rd.ReadLine());

            while (true)
            {
                // original_per_material_anim
                string original_per_material_anim = rd.ReadLine();
                if (original_per_material_anim != "<original_per_material_anim")
                {
                    Nintendo.Foundation.Contracts.Assertion.Operation.True(original_per_material_anim == "</original_per_material_anim_array>");
                    wt.WriteLine("{0}", original_per_material_anim);
                    break;
                }
                string index = rd.ReadLine();
                string name = rd.ReadLine();
                wt.WriteLine("\t{0} {1} {2}", original_per_material_anim, index, name);
                if (name.EndsWith(" />")) { continue; }

                // original_color_anim
                string original_color_anim_array = rd.ReadLine();
                string original_texsrt_anim_array;
                if (original_color_anim_array == "<original_color_anim_array")
                {
                    IfTextShaderParamAnimFormatter.Format_original_color_anim(rd, wt);
                    original_texsrt_anim_array = rd.ReadLine();
                }
                else
                {
                    original_texsrt_anim_array = original_color_anim_array;
                }

                // original_texsrt_anim
                string close_original_material_anim;
                if (original_texsrt_anim_array == "<original_texsrt_anim_array")
                {
                    IfTextShaderParamAnimFormatter.Format_original_texsrt_anim(rd, wt);
                    close_original_material_anim = rd.ReadLine();
                }
                else
                {
                    close_original_material_anim = original_texsrt_anim_array;
                }

                Nintendo.Foundation.Contracts.Assertion.Operation.True(close_original_material_anim == "</original_per_material_anim>");
                wt.WriteLine("\t{0}", close_original_material_anim);
            }
        }
        #endregion
    }
}
