﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // ボーンビジビリティアニメーションの刈り込みボーン圧縮
    public class IfBoneVisibilityAnimBoneCullCompressor
        : IfBoneVisibilityAnimCompressor
    {
        // コンストラクタ
        public IfBoneVisibilityAnimBoneCullCompressor() :
            base("IfBoneVisibilityAnimBoneCullCompressor_Log") { }

        // プロセス
        public override string Process
        {
            get { return "compress_bone_cull"; }
        }

        // 圧縮
        protected override void Compress()
        {
            CompressBoneCull(this.Target);

            // 不要になったストリームを削除する
            BoneVisibilityAnimCompressUtility.RemoveUselessStream(this.Target, this.Streams);
        }

        internal static void CompressBoneCull(bone_visibility_animType target)
        {
            bone_vis_bone_animType[] bone_anims =
                target.bone_vis_bone_anim_array.bone_vis_bone_anim;
            int boneAnimCount = bone_anims.Length;
            BoneVisAnimInfo[] boneAnimInfos = new BoneVisAnimInfo[boneAnimCount];
            BoneVisAnimInfo[] parent;

            // ボーンアニメーション情報の初期化
            for (int i = 0; i < boneAnimCount; i++)
            { boneAnimInfos[i] = new BoneVisAnimInfo(bone_anims[i]); }
            for (int i = 0; i < boneAnimCount; i++)
            { boneAnimInfos[i].Setup(boneAnimInfos); }

            // 削除可能なボーンの洗い出し
            bool update = true;
            while (update)
            {
                update = false;
                for (int i = 0; i < boneAnimCount; i++)
                {
                    bone_vis_bone_animType bone_anim = bone_anims[i];
                    BoneVisAnimInfo boneAnimInfo = boneAnimInfos[i];
                    if (boneAnimInfo.RemoveFlag) { continue; }
                    if (CheckRemovable(boneAnimInfo))
                    {
                        boneAnimInfo.RemoveFlag = true;
                        update = true;
                    }
                }
            }

            // 以下の条件に当てはまる場合はルートボーンを削除する。
            // - ボーン名が "nw4f_root" である
            // - ルートボーンの削除されない子供の数が 1 つだけ
            BoneVisAnimInfo rootAnimInfo = boneAnimInfos[0];
            BoneVisibilityAnimCompressUtility.GetThinOutBoneRef(boneAnimInfos, out parent);
            BoneVisAnimInfo[] rootChild = Array.FindAll(
                parent, delegate (BoneVisAnimInfo bone) { return (bone == rootAnimInfo); });
            if (rootAnimInfo.BoneAnim.bone_name == G3dConstant.RootBoneName &&
                (rootChild.Length <= 1))
            {
                rootAnimInfo.RemoveFlag = true;
            }

            // ボーン圧縮後のルートボーンを見つける。
            if (rootAnimInfo.RemoveFlag)
            {
                int idx = Array.FindIndex(
                    parent, delegate (BoneVisAnimInfo bone) { return (bone == rootAnimInfo); });
                // 全てのノードが削除される場合は idx が -1 になる。
                // フォーマッタがボーンが存在していない場合に対応していないので、ルートノードのみ残す。
                if (idx >= 0)
                {
                    rootAnimInfo = boneAnimInfos[idx];
                }
                else
                {
                    rootAnimInfo.RemoveFlag = false;
                }
            }

            // アニメーションが付いているボーンが削除されるか確認する
            BoneVisibilityAnimCompressUtility.CheckAnimationRemoved(boneAnimInfos);
            // 新しいアニメーションのインデックスを設定する
            BoneVisibilityAnimCompressUtility.SetNewIndex(rootAnimInfo);
            // アニメーションの削除
            BoneVisibilityAnimCompressUtility.RemoveBoneAnims(target, boneAnimInfos);
        }

        // 削除可能かチェック
        private static bool CheckRemovable(BoneVisAnimInfo bone_animInfo)
        {
            bone_vis_bone_animType bone_anim = bone_animInfo.BoneAnim;
            // 圧縮禁止
            if (!bone_anim.compress_enable) { return false; }

            // 描画に利用されている
            if (bone_animInfo.RenderMatrix) { return false; }

            // 子がいたら削除しない
            if (bone_animInfo.HasChild()) { return false; }

            return true;
        }
    }
}
