﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Reflection;
using System.Runtime;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;
using nw.g3d.toollib;
using System.Resources;

namespace nw.g3d.format
{
    // 中間ファイルフォーマッタ
    public class g3dformat : SimpleFilterTool<SimpleFilterToolParamsNotRequireXsdCheck>
    {
        // エントリポイント
        public static void Main()
        {
            string path = Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location);
            ProfileOptimization.SetProfileRoot(path);
            ProfileOptimization.StartProfile(Path.GetFileNameWithoutExtension(
                Assembly.GetExecutingAssembly().Location) + ".JIT.Profile");

            var helpResourceManager = new ResourceManager("nw.g3d.format.Resources.CommandLineHelp", typeof(g3dformat).Assembly);
            SimpleFilterToolParams.CustomDescriptionConverterFunc = (x, y) =>
            {
                return helpResourceManager.GetString(x);
            };

            g3dformat g3dformat = new g3dformat();
            G3dToolUtility.Run(delegate { g3dformat.Run(); });
        }

        // コンストラクタ
        public g3dformat() : base("nw.g3d.format.Resources.StringResource") { }

        // ファイルパスのチェック
        protected override bool CheckFilePath(string filePath)
        {
            if (!G3dPath.IsPath(filePath)) { return false; }
            return base.CheckFilePath(filePath);
        }

        // ファイル処理
        protected override void ProcessFile(int index, string filePath)
        {
            if (G3dPath.IsStreamBinaryPath(filePath))
            {
                List<G3dStream> stream_array = new List<G3dStream>();
                nw4f_3difType nw4f_3dif = IfBinaryReadUtility.Read(
                    stream_array, filePath, this.XsdBasePath);
                IfBinaryWriteUtility.Write(nw4f_3dif, stream_array, filePath, this.XsdBasePath);
            }
            else
            {
                nw4f_3difType nw4f_3dif = IfReadUtility.Read(filePath, this.XsdBasePath);
                IfWriteUtility.Write(nw4f_3dif, filePath);
            }
        }
    }
}
