﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace nw.g3d.ifcvtr
{
    /// <summary>
    /// List の拡張クラスです。
    /// </summary>
    public static class ListExtension
    {
        /// <summary>
        /// リストをリサイズします。
        /// </summary>
        /// <typeparam name="T">リストの要素型です。</typeparam>
        /// <param name="list">リサイズするリストです。</param>
        /// <param name="newSize">リサイズ後の新しいサイズです。</param>
        /// <param name="resetElement">初期化する値です。</param>
        public static void Resize<T>(this List<T> list, int newSize, T resetElement)
        {
            int currentSize = list.Count;
            if (newSize < currentSize)
            {
                list.RemoveRange(newSize, currentSize - newSize);
            }
            else if (newSize > currentSize)
            {
                if (newSize > list.Capacity)
                {
                    list.Capacity = newSize;
                }
                list.AddRange(Enumerable.Repeat(resetElement, newSize - currentSize));
            }
        }

        /// <summary>
        /// リストをリサイズします。
        /// </summary>
        /// <typeparam name="T">リストの要素型です。</typeparam>
        /// <param name="list">リサイズするリストです。</param>
        /// <param name="newSize">リサイズ後の新しいサイズです。</param>
        public static void Resize<T>(this List<T> list, int newSize) where T : new()
        {
            Resize(list, newSize, new T());
        }
    }
}
