﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using nw.g3d.toollib;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.ifassign
{
    internal abstract class AssignUtility
    {
        internal AssignUtility(g3difassignParams.SubCommandBase programOption)
        {
            this.SubCommand = programOption;
            this.DisableFileInfo = programOption.DisableFileInfo;
            this.MessageBuilder = new StringBuilder();
        }

        //---------------------------------------------------------------------
        // 処理
        internal abstract void Process();

        internal readonly g3difassignParams.SubCommandBase SubCommand;
        internal bool DisableFileInfo { get; set; }

        // 廃止予定の項目
        internal string DeprecatedMessage(shading_modelType shading_model)
        {
            var uniforms = from block in shading_model.block_var_array != null ? shading_model.block_var_array.block_var : Enumerable.Empty<block_varType>()
                           from uniform in block.uniform_var_array != null ? block.uniform_var_array.uniform_var : Enumerable.Empty<uniform_varType>()
                           select uniform;

            var builder = new StringBuilder();
            return builder.ToString();
        }

        // メッセージ
        public StringBuilder MessageBuilder { get; set; }
    }
}
