﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace G3dCombinerShaderConverter
{
    public class ScopedWorkDirectoryCreator : IDisposable
    {
        public string WorkDirectoryPath { get; }

        public ScopedWorkDirectoryCreator(string tempFolderPath)
        {
            this.WorkDirectoryPath = tempFolderPath;
            if (!System.IO.Directory.Exists(tempFolderPath))
            {
                System.IO.Directory.CreateDirectory(tempFolderPath);
            }
        }

        public virtual void Dispose()
        {
            System.IO.Directory.Delete(this.WorkDirectoryPath, true);
        }
    }
    public class ScopedFileCreator : IDisposable
    {
        public string FilePath { get; }

        public ScopedFileCreator(string filePath, bool skipCreateFile=false)
        {
            this.FilePath = filePath;
            if (skipCreateFile == false && !System.IO.File.Exists(filePath))
            {
                System.IO.File.Create(filePath);
            }
        }

        public virtual void Dispose()
        {
            System.IO.File.Delete(this.FilePath);
        }
    }

    public class IoUtility
    {
        public static void WriteMessage(string message)
        {
            Console.Write(message);
        }
        public static void WriteErrorMessage(string message)
        {
            Console.Error.Write(message);
        }
        public static void WriteMessageLine(string message)
        {
            WriteMessage(message + Environment.NewLine);
        }
        public static void WriteErrorMessageLine(string message)
        {
            WriteErrorMessage(message + Environment.NewLine);
        }

        [Conditional("DEBUG")]
        public static void WriteDebugMessageLine(string message)
        {
            WriteDebugMessage(message + Environment.NewLine);
        }

        [Conditional("DEBUG")]
        public static void WriteDebugMessage(string message)
        {
            IoUtility.WriteMessage(message);
        }
    }
}
