﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cassert>
#include <util/types.h>
#include <util/UtilError.h>
#include <util/UtilErrorCode.h>

#define NN_GFX_TOOL_ENDIAN_SWAP_IS_NOT_IMPLEMENTED		// TODO: EndianSwap には対応していません。

namespace nn {
namespace g3dTool {


//! @brief バイナリのアライメントの定義です。
enum BinaryAliment
{
    ALIGNMENT_DEFAULT = 8,
    ALIGNMENT_BLOCK = 8,
    // OpenGLは1のアライメントを要求
    ALIGNMENT_INDEX_STREAM = 8,  // Align to size of indices minimally; 32 or 64 bytes suggested.
    // OpenGLは1のアライメントを要求
    ALIGNMENT_VERTEX_STREAM = 8, // No minimum requirement, but 64 bytes suggested; see Attribute Buffers.
    ALIGNMENT_FILE = 8,
    ALIGNMENT_EXTERNAL_FILE = 256, // Use GX2_SHADER_ALIGNMENT (256 bytes).
    ALIGNMENT_MEMORY_POOL_ADDR = 4 * 1024,
    ALIGNMENT_MEMORY_POOL_SIZE = 4 * 1024,
};


}
}

//! @brief モデルシリアライザのバージョン定義です。
#define NN_G3D_MODEL_SERIALIZER_VERSION_MAJOR            ( 1 )
#define NN_G3D_MODEL_SERIALIZER_VERSION_MINOR            ( 3 )
#define NN_G3D_MODEL_SERIALIZER_VERSION_MICRO            ( 0 )
#define NN_G3D_MODEL_SERIALIZER_VERSION									\
    NN_UTIL_CREATE_SIGNATURE_4( NN_G3D_MODEL_SERIALIZER_VERSION_MAJOR,	\
                               NN_G3D_MODEL_SERIALIZER_VERSION_MINOR,	\
                               NN_G3D_MODEL_SERIALIZER_VERSION_MICRO,	\
                               0 )


#define NN_G3D_TOOL_BIN_DEFINE_ENUM_TABLE(type, name, table, ...)                                                \
namespace {                                                                                          \
const uint32_t tbl_##type##_##name##_##table[] = {                                                   \
    __VA_ARGS__                                                                                      \
};                                                                                                   \
}                                                                                                    \
uint32_t ToEnum_##table(nw::g3d::tool::g3dif::elem_##type::enum_##name value)                        \
{                                                                                                    \
    if (!(0 <= value || value < nw::g3d::tool::g3dif::elem_##type::num_##name))                      \
    {                                                                                                \
        THROW_ERROR(ERRCODE_UNKNOWN_ENUM, "Unknown enum value. %d", value);                          \
    }                                                                                                \
    return tbl_##type##_##name##_##table[value];                                                     \
}                                                                                                    \
static_assert(sizeof(tbl_##type##_##name##_##table) / sizeof(uint32_t) == nw::g3d::tool::g3dif::elem_##type::num_##name, \
    "Invalid table size.")
