﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/g3d_ResSceneAnim.h>
#include <g3dif/SceneAnim.h>
#include <bindefs.h>
#include <BinaryBlock.h>
#include <BinDictionary.h>
#include <BinAnimCurve.h>
#include <BinUserData.h>

namespace nn {
namespace g3dTool {

//! @brief カメラアニメーションデータのバイナリ化を行うクラスです。
class BinCameraAnim : public BinaryBlock
{
public:
    BinCameraAnim()
        : BinaryBlock()
        , m_pElem(nullptr)
        , m_CurveArray()
        , m_DicUserData()
        , m_UserDataArray()
    {
    }

    void Build(std::shared_ptr<Context> pCtx, const nw::g3d::tool::g3dif::elem_camera_anim& elem);
    virtual void CalculateSize();
    virtual void CalculateOffset( std::shared_ptr<Context> pCtx );
    virtual void Convert( std::shared_ptr<Context> pCtx );
    virtual void Adjust( std::shared_ptr<Context> pCtx );

    virtual void DumpLog() const
    {
        PRINT_SYSTEM_LOG("CameraAnim : %hs", m_pElem->camera_name.value.c_str());
    }

private:
    const nw::g3d::tool::g3dif::elem_camera_anim* m_pElem;

    std::vector<BinAnimCurve> m_CurveArray;
    std::vector<const nw::g3d::tool::g3dif::elem_camera_anim_target*> m_TargetAnimArray;

    BinDictionary m_DicUserData;
    std::vector<BinUserData> m_UserDataArray;

    enum
    {
        //CAMERA,
        ChunkType_Curve,
        ChunkType_BaseValue,
        ChunkType_UserDataData,
        ChunkType_Count
    };

    Chunk m_Chunk[ChunkType_Count];
};

//! @brief ライトアニメーションデータのバイナリ化を行うクラスです。
class BinLightAnim : public BinaryBlock
{
public:
    BinLightAnim()
        : BinaryBlock()
        , m_pElem(nullptr)
        , m_CurveArray()
        , m_Flag(0)
        , m_LightAnimTarget()
        , m_TargetOffset()
        , m_BaseValue(0)
        , m_DicUserData()
        , m_UserDataArray()
    {
    }

    void Build(std::shared_ptr<Context> pCtx, const nw::g3d::tool::g3dif::elem_light_anim& elem);
    virtual void CalculateSize();
    virtual void CalculateOffset( std::shared_ptr<Context> pCtx );
    virtual void Convert( std::shared_ptr<Context> pCtx );
    virtual void Adjust( std::shared_ptr<Context> pCtx );

    virtual void DumpLog() const
    {
        PRINT_SYSTEM_LOG("LightAnim : %hs", m_pElem->light_name.value.c_str());
    }

private:
    const nw::g3d::tool::g3dif::elem_light_anim* m_pElem;

    std::vector<BinAnimCurve> m_CurveArray;
    uint16_t m_Flag;

    std::vector<const nw::g3d::tool::g3dif::elem_light_anim_target*> m_LightAnimTarget;
    std::vector<int> m_TargetOffset;
    int m_BaseValue;

    BinDictionary m_DicUserData;
    std::vector<BinUserData> m_UserDataArray;

    enum
    {
        //LIGHT,
        ChunkType_Curve,
        ChunkType_BaseValue,
        ChunkType_UserDataData,
        ChunkType_Count
    };

    Chunk m_Chunk[ChunkType_Count];
};

//! @brief フォグアニメーションデータのバイナリ化を行うクラスです。
class BinFogAnim : public BinaryBlock
{
public:
    BinFogAnim()
        : BinaryBlock()
        , m_pElem(nullptr)
        , m_CurveArray()
        , m_DicUserData()
        , m_UserDataArray()
    {
    }

    void Build(std::shared_ptr<Context> pCtx, const nw::g3d::tool::g3dif::elem_fog_anim& elem);
    virtual void CalculateSize();
    virtual void CalculateOffset( std::shared_ptr<Context> pCtx );
    virtual void Convert( std::shared_ptr<Context> pCtx );
    virtual void Adjust( std::shared_ptr<Context> pCtx );

    virtual void DumpLog() const
    {
        PRINT_SYSTEM_LOG("FogAnim : %hs", m_pElem->fog_name.value.c_str());
    }

private:
    const nw::g3d::tool::g3dif::elem_fog_anim* m_pElem;

    std::vector<BinAnimCurve> m_CurveArray;

    BinDictionary m_DicUserData;
    std::vector<BinUserData> m_UserDataArray;

    enum
    {
        //FOG,
        ChunkType_Curve,
        ChunkType_BaseValue,
        ChunkType_UserDataData,
        ChunkType_Count
    };

    Chunk m_Chunk[ChunkType_Count];
};

//! @brief シーンアニメーションデータのバイナリ化を行うクラスです。
class BinSceneAnim : public BinaryBlock
{
public:
    BinSceneAnim()
        : BinaryBlock()
        , m_pElem(nullptr)
        , m_CameraAnimArray()
        , m_LightAnimArray()
        , m_FogAnimArray()
        , m_DicCameraAnim()
        , m_DicLightAnim()
        , m_DicFogAnim()
        , m_DicUserData()
        , m_UserDataArray()
    {
    }

    void Build(std::shared_ptr<Context> pCtx, const nw::g3d::tool::g3dif::elem_scene_anim& elem);
    virtual void CalculateSize();
    virtual void CalculateOffset( std::shared_ptr<Context> pCtx );
    virtual void Convert( std::shared_ptr<Context> pCtx );

    virtual void DumpLog() const
    {
        PRINT_SYSTEM_LOG("SceneAnim : %hs", m_pElem->name.c_str());
    }

private:
    const nw::g3d::tool::g3dif::elem_scene_anim* m_pElem;

    std::vector<BinCameraAnim> m_CameraAnimArray;
    std::vector<BinLightAnim> m_LightAnimArray;
    std::vector<BinFogAnim> m_FogAnimArray;
    BinDictionary m_DicCameraAnim;
    BinDictionary m_DicLightAnim;
    BinDictionary m_DicFogAnim;

    BinDictionary m_DicUserData;
    std::vector<BinUserData> m_UserDataArray;

    enum
    {
        SCENE_ANIM,
        CAMERA_ANIM,
        LIGHT_ANIM,
        FOG_ANIM,
        ChunkType_UserDataData,
        ChunkType_Count
    };

    Chunk m_Chunk[ChunkType_Count];
};

}
}
