﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/g3d_ResAnimCurve.h>
#include <g3dif/AnimCurve.h>
#include <bindefs.h>
#include <BinaryBlock.h>

namespace nn {
namespace g3dTool {

//! @brief アニメションカーブデータのバイナリ化を行うクラスです。
class BinAnimCurve : public BinaryBlock
{
public:
    BinAnimCurve()
        : BinaryBlock()
        , m_pElem(nullptr)
        , m_TargetOffset(0)
        , m_Type(FLOAT)
        , m_IsDegreeValue(false)
        , m_FVSPairArray()
    {
    }

    void Build(std::shared_ptr<Context> pCtx, const nw::g3d::tool::g3dif::elem_anim_curve& elem);
    virtual void CalculateSize();
    virtual void Convert( std::shared_ptr<Context> pCtx );

    virtual void DumpLog() const
    {
        PRINT_SYSTEM_LOG("AnimCurve");
    }

    enum Type
    {
        FLOAT,
        INT,
        BOOL,
        NUM_TYPE
    };

    void SetType(Type type) { m_Type = type; }
    Type GetType() const { return m_Type; }
    void SetTargetOffset(ptrdiff_t offset) { m_TargetOffset = offset; }

    void QuantizeFrame(std::shared_ptr<Context> pCtx, nn::g3d::ResAnimCurveData& curve);
    void QuantizeHermite(std::shared_ptr<Context> pCtx, nn::g3d::ResAnimCurveData& curve);
    void QuantizeLinear(std::shared_ptr<Context> pCtx, nn::g3d::ResAnimCurveData& curve);
    void QuantizeStepFloat(std::shared_ptr<Context> pCtx, nn::g3d::ResAnimCurveData& curve);
    void QuantizeStepInt(std::shared_ptr<Context> pCtx, nn::g3d::ResAnimCurveData& curve);
    void QuantizeStepBool(std::shared_ptr<Context> pCtx, nn::g3d::ResAnimCurveData& curve);

    void SetDegreeValue(bool degreeValue) { m_IsDegreeValue = degreeValue; }

private:
    const nw::g3d::tool::g3dif::elem_anim_curve* m_pElem;

    ptrdiff_t m_TargetOffset;
    Type m_Type;
    bool m_IsDegreeValue;
    static const int ALIGNMENT_FLAG = 32;

    struct FVSPair
    {
        union
        {
            float f[7];
            struct Hermite
            {
                float frame0, value0, in_slope0, out_slope0, frame1, value1, in_slope1;
            } hermite;
            struct Linear
            {
                float frame0, value0, frame1, value1;
            } linear;
            struct Step
            {
                float frame0, value0;
            } step;
        };
    };

    std::vector<FVSPair> m_FVSPairArray;

    enum
    {
        ChunkType_Frame,
        ChunkType_Key,
        ChunkType_Count
    };

    Chunk m_Chunk[ChunkType_Count];
};

}
}
