﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "GlobalOptionParser.h"

namespace nn {
namespace g3dTool {

GlobalOptionParser::GlobalOptionParser()
{
    SetArgs( &m_InputArgArray );

    // コマンドラインオプションを定義します。
    {
        SetOption( m_OptionDefinitions.output.Define(
            false, 'o', "output", "Specify output filename." ) );
        SetOption( m_OptionDefinitions.rootPath.Define(
            false, 'r', "root-path", "Specify the rootpath of input files." ) );
        SetOption( m_OptionDefinitions.version.Define(
            false, "version", "Display version information and exit." ) );
        SetOption( m_OptionDefinitions.help.Define(
            false, 'h', "help", "Display this help and exit." ) );
        SetOption( m_OptionDefinitions.silent.Define(
            false, 's', "silent", "Don't display progress information." ) );
        SetOption( m_OptionDefinitions.ignoreAssign.Define(
            false, 'i', "ignore-assign", "Ignore cheacking the exist of material assign." ) );
        SetOption( m_OptionDefinitions.externalFile.Define(
            false, "external-file", "Bring in the specified file as it is [LOCAL]." ) );
        SetOption( m_OptionDefinitions.verify.Define(
            false, "verify", "Verify intermediate files and show the error message." ) );
        SetOption( m_OptionDefinitions.ignoreVersion.Define(
            false, "ignore-version", "Internal use option." ) );
        SetOption( m_OptionDefinitions.viewer.Define(
            false, "viewer", "Internal use option." ) );
        SetOption( m_OptionDefinitions.editor.Define(
            false, "editor", "Internal use option." ) );
        SetOption( m_OptionDefinitions.disableAttributeAlignmentSort.Define(
            false, "disable-attribute-alignment-sort", "Internal use option." ) );
    }
}

void GlobalOptionParser::Parse( const std::vector< std::string >& srcStrArray )
{
    const char** strPtrArray = new( const char* [ srcStrArray.size() ] );
    for( int idx = 0; idx < static_cast< int >( srcStrArray.size() ); ++idx )
    {
        strPtrArray[ idx ] = reinterpret_cast< const char* const >( srcStrArray[ idx ].c_str() );
    }
    nn::gfxTool::CommandLineParser::Parse( static_cast< int >( srcStrArray.size() ), strPtrArray );
    delete[] strPtrArray;
}

}
}
