﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfxTool/gfxTool_CommandLineParser.h>

namespace nn {
namespace g3dTool {

class FileOptionParser : private nn::gfxTool::CommandLineParser
{
public:
    //! @brief コマンドラインオプションを定義する構造体です。
    struct CommandLineOptionDefinitions
    {
        nn::gfxTool::CommandLineOption< nn::gfxTool::Custom< std::string >::Type > externalFileAlign;
    };

    FileOptionParser();

    virtual ~FileOptionParser()
    {
    }

    //! @brief 位置引数を取得します。
    const nn::gfxTool::Custom< std::vector< nn::gfxTool::Custom< std::string >::Type > >::Type&
    GetInputArgs() const
    {
        return m_InputArgArray;
    }

    //! @brief コマンドラインオプションを取得します。
    const CommandLineOptionDefinitions& GetCommandLineOptionDefinitions() const
    {
        return m_OptionDefinitions;
    }

    //!< @brief パースします。
    void Parse( const std::vector< std::string >& strArray );

    //!< @brief ヘルプを表示します。
    void PrintHelp( const char* pToolName, const char* pToolDescription )
    {
        nn::gfxTool::CommandLineParser::PrintHelp( pToolName, pToolDescription );
    }

    //!< @brief パーサを初期化しパースできる状態にします。
    void ResetOptions( void );

private:
    //! @brief オプションの定義と値を保持するオブジェクトです。
    CommandLineOptionDefinitions	m_OptionDefinitions;

    //! @brief 位置引数（オプションを伴わない引数）の配列です。
    nn::gfxTool::Custom< std::vector< nn::gfxTool::Custom< std::string >::Type > >::Type	m_InputArgArray;

};

}
}
