﻿namespace G3dCore.Plugins
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.Logs;
    using Opal.Plugins;

    /// <summary>
    /// コマンドライン引数を受け取り処理を実行するプラグインの抽象クラスです。
    /// </summary>
    public abstract class CommandLineExecutorPlugin : IPlugin
    {
        /// <summary>
        /// ログマネージャーを取得設定します。
        /// </summary>
        public ILogManager LogManager { get; set; }

        /// <summary>
        /// 処理を実行します。
        /// </summary>
        /// <param name="args">引数です。</param>
        /// <returns>結果を返します。</returns>
        public abstract Result Execute(params string[] args);

        /// <summary>
        /// エラーログを出力します。
        /// </summary>
        /// <param name="message">メッセージです。</param>
        protected void WriteError(string message)
        {
            var logger = new Logger();
            logger.Error(message);
            this.WriteLog(logger);
        }

        /// <summary>
        /// 情報ログを出力します。
        /// </summary>
        /// <param name="message">メッセージです。</param>
        protected void WriteInfo(string message)
        {
            var logger = new Logger();
            logger.Info(message);
            this.WriteLog(logger);
        }

        /// <summary>
        /// ログを出力します。
        /// </summary>
        /// <param name="logger">出力するロガーです。</param>
        protected void WriteLog(Logger logger)
        {
            Debug.Assert(logger != null);

            if (this.LogManager != null)
            {
                this.LogManager.PushLogger(logger);
                this.LogManager.FlushAll();
            }
        }

        /// <summary>
        /// 結果を格納するクラスです。
        /// </summary>
        public class Result
        {
            public bool IsSuccessful { get; set; }
            public string Message { get; set; }
            public object Parameter { get; set; }

            public Result()
            {
                this.IsSuccessful = false;
                this.Message = string.Empty;
                this.Parameter = null;
            }
        }
    }
}
