﻿namespace G3dCore.Entities
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using nw.g3d.nw4f_3dif;
    using Opal.Security.Cryptography;

    /// <summary>
    /// 頂点シェーダ設定のエンティティクラスです。
    /// </summary>
    public class VertexShader : Entity<vertex_shaderType>
    {
        private string path = string.Empty;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public VertexShader()
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="data">設定するデータです。</param>
        public VertexShader(vertex_shaderType data)
            : this()
        {
            this.path = data.path ?? string.Empty;
        }

        /// <summary>
        /// パスを取得設定します。
        /// </summary>
        public string Path
        {
            get
            {
                return this.path;
            }

            set
            {
                this.SetProperty(ref this.path, value ?? string.Empty, () => this.CalcCRC());
            }
        }

        /// <summary>
        /// 現在のインスタンスのコピーである新しいオブジェクトを作成します。
        /// </summary>
        /// <returns>現在のインスタンスのコピーである新しいオブジェクトを返します。</returns>
        public override IEntity Clone()
        {
            var instance = new VertexShader();
            instance.path = this.path;

            return instance;
        }

        /// <summary>
        /// 出力データを作成します。
        /// </summary>
        /// <returns>出力データのインスタンスを返します。</returns>
        public override vertex_shaderType CreateWriteData()
        {
            if (string.IsNullOrWhiteSpace(this.path))
            {
                return null;
            }

            vertex_shaderType instance = new vertex_shaderType();
            instance.path = this.path;

            return instance;
        }

        /// <summary>
        /// エンティティのCRC を作成します。（内部処理用）
        /// </summary>
        /// <returns>CRCの値を返します。</returns>
        protected override uint CreateCRCInternal()
        {
            Debug.Assert(this.path != null);

            CRC32 crc = new CRC32();
            List<byte> buffers = new List<byte>();
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.path)));

            var hashValue = crc.ComputeHashUInt32(buffers.ToArray());
            return hashValue;
        }
    }
}
