﻿namespace G3dCore.Entities
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using nw.g3d.nw4f_3dif;

    /// <summary>
    /// 中間ファイルの変更情報のエンティティクラスです。
    /// </summary>
    public class Modify : ObservableEntity<modifyType>
    {
        private string toolName = string.Empty;
        private string toolVersion = string.Empty;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public Modify()
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="data">設定するデータです。</param>
        public Modify(modifyType data)
        {
            this.toolName = data.tool_name;
            this.toolVersion = data.tool_version;
        }

        /// <summary>
        /// 中間ファイルを変更したツールの名前を取得設定します。
        /// </summary>
        public string ToolName
        {
            get
            {
                return this.toolName;
            }

            set
            {
                this.SetProperty(ref this.toolName, value);
            }
        }

        /// <summary>
        /// 中間ファイルを変更したツールのバージョンを取得設定します。
        /// </summary>
        public string ToolVersion
        {
            get
            {
                return this.toolVersion;
            }

            set
            {
                this.SetProperty(ref this.toolVersion, value);
            }
        }

        /// <summary>
        /// 現在のインスタンスのコピーである新しいオブジェクトを作成します。
        /// </summary>
        /// <returns>現在のインスタンスのコピーである新しいオブジェクトを返します。</returns>
        public override IEntity Clone()
        {
            var instance = new Modify();
            instance.toolName = this.toolName;
            instance.toolVersion = this.toolVersion;

            return instance;
        }

        /// <summary>
        /// 出力データを作成します。
        /// </summary>
        /// <returns>出力データのインスタンスを返します。</returns>
        public override modifyType CreateWriteData()
        {
            var instance = new modifyType();
            instance.tool_name = this.toolName;
            instance.tool_version = this.toolVersion;

            return instance;
        }

        /// <summary>
        /// エンティティのCRC を作成します。（内部処理用）
        /// </summary>
        /// <returns>CRCの値を返します。</returns>
        protected override uint CreateCRCInternal()
        {
            return 0;
        }
    }
}
