﻿namespace G3dCore.Entities
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using nw.g3d.nw4f_3dif;
    using Opal.Security.Cryptography;

    /// <summary>
    /// マクロのエンティティクラスです。
    /// </summary>
    public class Macro : Entity<macroType>
    {
        private int index = 0;
        private string name = string.Empty;
        private string value = string.Empty;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public Macro()
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="data">設定するデータです。</param>
        public Macro(macroType data)
            : this()
        {
            this.index = data.index;
            this.name = data.name ?? string.Empty;
            this.value = data.value ?? string.Empty;
        }

        /// <summary>
        /// インデックスを取得設定します。
        /// </summary>
        public int Index
        {
            get
            {
                return this.index;
            }

            set
            {
                this.SetProperty(ref this.index, value);
            }
        }

        /// <summary>
        /// 名前を取得設定します。
        /// </summary>
        public string Name
        {
            get
            {
                return this.name;
            }

            set
            {
                this.SetProperty(ref this.name, value ?? string.Empty, () => this.CalcCRC());
            }
        }

        /// <summary>
        /// 値を取得設定します。
        /// </summary>
        public string Value
        {
            get
            {
                return this.value;
            }

            set
            {
                this.SetProperty(ref this.value, value ?? string.Empty, () => this.CalcCRC());
            }
        }

        /// <summary>
        /// 現在のインスタンスのコピーである新しいオブジェクトを作成します。
        /// </summary>
        /// <returns>現在のインスタンスのコピーである新しいオブジェクトを返します。</returns>
        public override IEntity Clone()
        {
            var instance = new Macro();
            instance.index = this.index;
            instance.name = this.name;
            instance.value = this.value;

            return instance;
        }

        /// <summary>
        /// 出力データを作成します。
        /// </summary>
        /// <returns>出力データのインスタンスを返します。</returns>
        public override macroType CreateWriteData()
        {
            macroType instance = new macroType();
            instance.index = this.index;
            instance.name = this.name;
            instance.value = this.value;

            return instance;
        }

        /// <summary>
        /// エンティティのCRC を作成します。（内部処理用）
        /// </summary>
        /// <returns>CRCの値を返します。</returns>
        protected override uint CreateCRCInternal()
        {
            Debug.Assert(this.name != null);
            Debug.Assert(this.value != null);

            // Index プロパティは、出力時に計算しなおすので、CRCの計算対象外
            CRC32 crc = new CRC32();
            List<byte> buffers = new List<byte>();
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.name)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.value)));

            var hashValue = crc.ComputeHashUInt32(buffers.ToArray());
            return hashValue;
        }
    }
}
