﻿namespace G3dCore.Entities
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// 中間ファイルの種類です。
    /// </summary>
    public enum G3dKind
    {
        /// <summary>
        /// 無効な種類です。
        /// </summary>
        Invalid,

        /// <summary>
        /// モデルです。
        /// </summary>
        Model,

        /// <summary>
        /// テクスチャです。
        /// </summary>
        Texture,

        /// <summary>
        /// スケルタルアニメです。
        /// </summary>
        SkeletalAnim,

        /// <summary>
        /// シェーダパラメータアニメです。
        /// </summary>
        ShaderParamAnim,

        /// <summary>
        /// テクスチャパターンアニメです。
        /// </summary>
        TexPatternAnim,

        /// <summary>
        /// ボーンビジビリティアニメです。
        /// </summary>
        BoneVisibilityAnim,

        /// <summary>
        /// マテリアルビジビリティアニメです。
        /// </summary>
        MatVisibilityAnim,

        /// <summary>
        /// シェイプアニメです。
        /// </summary>
        ShapeAnim,

        /// <summary>
        /// シーンアニメです。
        /// </summary>
        SceneAnim,

        /// <summary>
        /// シェーダ設定です。
        /// </summary>
        ShaderConfig,

        /// <summary>
        /// シェーダ定義です。
        /// </summary>
        ShaderDefinition,

        /// <summary>
        /// シェーダバリエーションです。
        /// </summary>
        ShaderVariation
    }
}
