﻿namespace ShaderAssistExAddons.Menus
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.Composition;
    using System.Diagnostics;
    using System.IO;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using G3dCore.IO;
    using G3dCore.Modules.ErrorView;
    using G3dCore.Resources;
    using G3dCore.Storages;
    using Microsoft.Win32;
    using Opal.App;
    using Opal.Menus;
    using Opal.Plugins;
    using ShaderAssistExAddons.Modules.ParamCode;

    /// <summary>
    /// ファイル開くメニュークラスです。
    /// </summary>
    [Export(typeof(IPlugin))]
    public sealed class OpenFileMenu : CommandableMenuPlugin
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public OpenFileMenu()
            : base("OpenFile", Properties.Resources.ShaderParamAutoGeneration, 0)
        {
            this.SetCommand(param => this.DoCommand(param), param => { return this.CanDoCommand(param); });
        }

        /// <summary>
        /// メニュー内のどの種類かを取得します。
        /// </summary>
        public override MenuCategory Category
        {
            get
            {
                return MenuCategory.FileOpen;
            }
        }

        /// <summary>
        /// コマンドを実行します。
        /// </summary>
        /// <param name="parameter">コマンドのパラメータです。</param>
        private void DoCommand(object parameter)
        {
            AppManager.WriteDebug("ShaderParamAutoGenerationMenu");

            var dialog = new OpenFileDialog();
            dialog.Reset();
            dialog.Title = "開く";
            dialog.Filter = "Excel ブック (*.xlsx)|*.xlsx";
            dialog.Multiselect = false;
            if (dialog.ShowDialog().GetValueOrDefault())
            {
                this.MakeParamCode(dialog.FileName);
            }
        }

        /// <summary>
        /// コマンドが実行可能か判定します。
        /// </summary>
        /// <param name="parameter">コマンドのパラメータです。</param>
        /// <returns>実行可能な場合は、true を返します。</returns>
        private bool CanDoCommand(object parameter)
        {
            return true;
        }

        private void MakeParamCode(string inputFilePath)
        {
            // TODO: 3dExcelToShaderAnnotation の処理に置き換える
#if false
            var makeParamCode = new MakeParamCodeExecutor();

            using (var logger = new ErrorViewLogger())
            {
                var result = makeParamCode.Execute(inputFilePath);

                if (!result.IsSuccessful)
                {
                    var log = new ErrorViewLog(ErrorViewLog.CategoryType.Error);
                    log.Summary = result.ErrorMessage;
                    logger.Add(log);

                    return;
                }
            }

            string outputPath = string.Empty;
            string expandedFileDir = PathUtility.GetExpandEnvironmentVariable(makeParamCode.AutogenFileDir);

            SaveFileDialog dialog = new SaveFileDialog();
            dialog.Title = Labels.SaveAutoGeneratedCode;
            dialog.FileName = makeParamCode.AutogenFileName;
            dialog.Filter = Labels.FilterShaderSource;
            dialog.FilterIndex = 2;
            dialog.InitialDirectory = expandedFileDir;

            if (dialog.ShowDialog() == true)
            {
                outputPath = dialog.FileName;
            }

            if (string.IsNullOrEmpty(outputPath))
            {
                return;
            }

            using (var logger = new ErrorViewLogger())
            {
                try
                {
                    makeParamCode.Write(outputPath);
                }
                catch (Exception e)
                {
                    var log = new ErrorViewLog(ErrorViewLog.CategoryType.Error);
                    log.Summary = string.Format(Messages.ErrorSaveFileError, Path.GetFileName(outputPath));
                    logger.Add(log);

                    Exception ex = e;
                    while (ex != null)
                    {
#if DEBUG
                        log.Details += ex.ToString();
#else
                    if (!string.IsNullOrEmpty(ex.Message))
                    {
                        log.Details += ex.Message;
                    }
#endif
                        ex = ex.InnerException;
                    }

                    return;
                }
            }
#endif
        }
    }
}
