﻿namespace ShaderAssistAddons.Modules.ShaderConfig.Views
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Controls;
    using System.Windows.Data;
    using System.Windows.Documents;
    using System.Windows.Input;
    using System.Windows.Media;
    using System.Windows.Media.Imaging;
    using System.Windows.Navigation;
    using System.Windows.Shapes;
    using ShaderAssistAddons.Modules.ShaderConfig.ViewModels;
    using ShaderAssistAddons.Resources;

    /// <summary>
    /// ShaderConfigView.xaml の相互作用ロジック
    /// </summary>
    public partial class ShaderConfigView : UserControl
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public ShaderConfigView()
        {
            this.InitializeComponent();
        }

        private void ToolBar_Loaded(object sender, RoutedEventArgs e)
        {
            ToolBar toolBar = sender as ToolBar;

            var overflowGrid = toolBar.Template.FindName("OverflowGrid", toolBar) as FrameworkElement;
            if (overflowGrid != null)
            {
                overflowGrid.Visibility = Visibility.Collapsed;
            }

            var mainPanelBorder = toolBar.Template.FindName("MainPanelBorder", toolBar) as FrameworkElement;
            if (mainPanelBorder != null)
            {
                mainPanelBorder.Margin = new Thickness();
            }
        }

        private void valiationListHeader_Click(object sender, RoutedEventArgs e)
        {
            GridViewColumnHeader clickedHeader = e.OriginalSource as GridViewColumnHeader;
            if (clickedHeader == null)
            {
                return;
            }

            var viewModel = variationListView.DataContext as ShaderViewModel;
            if (viewModel != null)
            {
                if ((string)clickedHeader.Content == ShaderConfigMessage.Output)
                {
                    viewModel.SetNextSortDescription(ShaderViewModel.VariationColumnTypes.Output);
                }
                else if ((string)clickedHeader.Content == ShaderConfigMessage.Id)
                {
                    viewModel.SetNextSortDescription(ShaderViewModel.VariationColumnTypes.Id);
                }
                else if ((string)clickedHeader.Content == ShaderConfigMessage.Choice)
                {
                    viewModel.SetNextSortDescription(ShaderViewModel.VariationColumnTypes.Choice);
                }
                else if ((string)clickedHeader.Content == ShaderConfigMessage.ChoiceShaderDefinition)
                {
                    viewModel.SetNextSortDescription(ShaderViewModel.VariationColumnTypes.ChoiceShaderDefinition);
                }
                else if ((string)clickedHeader.Content == ShaderConfigMessage.Default)
                {
                    viewModel.SetNextSortDescription(ShaderViewModel.VariationColumnTypes.Default);
                }
                else if ((string)clickedHeader.Content == ShaderConfigMessage.DefaultShaderDefinition)
                {
                    viewModel.SetNextSortDescription(ShaderViewModel.VariationColumnTypes.DefaultShaderDefinition);
                }
                else if ((string)clickedHeader.Content == ShaderConfigMessage.Branch)
                {
                    viewModel.SetNextSortDescription(ShaderViewModel.VariationColumnTypes.Branch);
                }
                else if ((string)clickedHeader.Content == ShaderConfigMessage.SelectedOption)
                {
                    viewModel.SetNextSortDescription(ShaderViewModel.VariationColumnTypes.SelectedOption);
                }

                viewModel.SetSortDescriptions();
            }
        }

        private void macroListHeader_Click(object sender, RoutedEventArgs e)
        {
            GridViewColumnHeader clickedHeader = e.OriginalSource as GridViewColumnHeader;
            if (clickedHeader == null)
            {
                return;
            }

            var viewModel = macroListView.DataContext as ShaderViewModel;
            if (viewModel != null)
            {
                if ((string)clickedHeader.Content == ShaderConfigMessage.Name)
                {
                    viewModel.SetNextSortDescription(ShaderViewModel.MacroColumnTypes.Name);
                }
                else if ((string)clickedHeader.Content == ShaderConfigMessage.Value)
                {
                    viewModel.SetNextSortDescription(ShaderViewModel.MacroColumnTypes.Value);

                }

                viewModel.SetSortDescriptions();
            }
        }

        private void shaderSourceListHeader_Click(object sender, RoutedEventArgs e)
        {
            GridViewColumnHeader clickedHeader = e.OriginalSource as GridViewColumnHeader;
            if (clickedHeader == null)
            {
                return;
            }

            ShaderSourceListViewModel viewModel = shaderSourceListView.DataContext as ShaderSourceListViewModel;
            if (viewModel != null)
            {
                if ((string)clickedHeader.Content == ShaderConfigMessage.FileType)
                {
                    viewModel.SetNextSortDescription(ShaderSourceListViewModel.ColumnTypes.FileType);
                }
                else if ((string)clickedHeader.Content == ShaderConfigMessage.IncludePath)
                {
                    viewModel.SetNextSortDescription(ShaderSourceListViewModel.ColumnTypes.IncludePath);
                }
                else if ((string)clickedHeader.Content == ShaderConfigMessage.FilePath)
                {
                    viewModel.SetNextSortDescription(ShaderSourceListViewModel.ColumnTypes.FilePath);
                }

                viewModel.SetSortDescriptions();
            }
        }
    }
}
